use super::{
    common_args::{
        CommonLabelArgs, CommonProjectArgs, ContentArgs, DeleteArgs, DescriptionArgs, ListArgs,
        MandatoryContentArgs, PriorityArgs,
    },
    due_date::{DueDateArgs, DueDateTime},
};
use serde::{Deserialize, Serialize};
use structopt::StructOpt;

pub(super) fn run_task(args: Args) {
    match args {
        Args::List { ..
            // list_args,
            // project_args,
            // label_args,
            // completed,
            // priority_args,
            // date_args,
        } => todo!(),
        Args::New { .. } => todo!(),
        Args::Update { .. } => todo!(),
        Args::Delete { .. } => todo!(),
    }
}

#[derive(Debug, StructOpt)]
pub(super) enum Args {
    List {
        #[structopt(flatten)]
        list_args: ListArgs,
        #[structopt(flatten)]
        project_args: CommonProjectArgs,
        #[structopt(flatten)]
        label_args: CommonLabelArgs,
        #[structopt(short, long)]
        completed: bool,
        #[structopt(flatten)]
        priority_args: PriorityArgs,
        #[structopt(flatten)]
        date_args: DueDateArgs,
    },
    New {
        #[structopt(flatten)]
        mandatory_content_args: MandatoryContentArgs,
        #[structopt(flatten)]
        description_args: DescriptionArgs,
        #[structopt(flatten)]
        project_args: CommonProjectArgs,
        #[structopt(flatten)]
        label_args: CommonLabelArgs,
        #[structopt(flatten)]
        priority_args: PriorityArgs,
        #[structopt(flatten)]
        date_args: DueDateArgs,
    },
    Update {
        #[structopt(short, long)]
        id: u32,
        #[structopt(flatten)]
        content_args: ContentArgs,
        #[structopt(flatten)]
        description_args: DescriptionArgs,
        #[structopt(flatten)]
        project_args: CommonProjectArgs,
        #[structopt(flatten)]
        label_args: CommonLabelArgs,
        #[structopt(flatten)]
        priority_args: PriorityArgs,
        #[structopt(flatten)]
        date_args: DueDateArgs,
    },
    Delete {
        #[structopt(flatten)]
        delete_args: DeleteArgs,
    },
}

/// Todoist model
#[derive(Debug, Serialize, Deserialize)]
struct Task {
    id: u32,
    project_id: Option<u32>,
    content: String,
    description: Option<String>,
    completed: bool,
    label_ids: Option<Vec<u32>>,
    priority: u8,
    due: Option<DueDateTime>,
    url: String,
    // IGNORED: parent_id; order; comment_count; assignee; assigner
}

impl Default for Task {
    fn default() -> Self {
        Self {
            id: 0,
            project_id: None,
            content: String::from(""),
            description: None,
            completed: false,
            label_ids: None,
            priority: 1,
            due: None,
            url: String::from(""),
        }
    }
}
