use super::common_args::{DeleteArgs, ListArgs, MandatoryNameArgs, NameArgs};
use serde::{Deserialize, Serialize};
use structopt::StructOpt;

pub(super) fn run_project(args: Args) {
    match args {
        Args::List { .. } => todo!(),
        Args::New { .. } => todo!(),
        Args::Update { .. } => todo!(),
        Args::Delete { .. } => todo!(),
    }
}

#[derive(Debug, StructOpt)]
pub(crate) enum Args {
    List {
        #[structopt(flatten)]
        list_args: ListArgs,
        #[structopt(flatten)]
        name: NameArgs,
    },
    New {
        #[structopt(flatten)]
        mandatory_name_args: MandatoryNameArgs,
    },
    Update {
        #[structopt(short, long)]
        id: u32,
        #[structopt(flatten)]
        name_args: NameArgs,
    },
    Delete {
        #[structopt(flatten)]
        delete_args: DeleteArgs,
    },
}

/// Todoist model
#[derive(Debug, Clone, Eq, PartialEq, Serialize, Deserialize)]
pub(crate) struct Project {
    id: u32,
    name: String,
    /**
    A numeric ID representing the color of the project icon; refer to the id column in the
    colors guide for more info; https://developer.todoist.com/guides/#colors
    */
    color: Option<u32>,
    favorite: Option<bool>,
    /**
    Whether the project is Inbox (read-only, true or otherwise this property is not sent).
    */
    inbox_project: Option<bool>,
    url: String,
    // IGNORED: parent_id; order; comment_count; shared; team_inbox; sync_id
}

impl Default for Project {
    fn default() -> Self {
        Self {
            id: 0,
            name: "".to_string(),
            color: None,
            favorite: None,
            inbox_project: Some(true),
            url: "".to_string(),
        }
    }
}
