use structopt::StructOpt;

#[derive(Debug, StructOpt)]
pub(crate) struct ContentArgs {
    #[structopt(short, long)]
    pub content: Option<String>,
}

#[derive(Debug, StructOpt)]
pub(crate) struct MandatoryContentArgs {
    #[structopt(short, long)]
    pub content: String,
}

#[derive(Debug, StructOpt)]
pub(crate) struct DescriptionArgs {
    #[structopt(long = "desc")]
    pub description: Option<String>,
}

#[derive(Debug, StructOpt)]
pub(crate) struct NameArgs {
    #[structopt(short, long)]
    pub name: Option<String>,
}

#[derive(Debug, StructOpt)]
pub(crate) struct MandatoryNameArgs {
    #[structopt(short, long)]
    pub name: String,
}

#[derive(Debug, StructOpt)]
pub(crate) struct PagingArgs {
    #[structopt(short, long, default_value = "10")]
    pub max_records: u32,
    #[structopt(long, default_value = "1")]
    pub page: u8,
}

#[derive(Debug, StructOpt)]
pub(crate) struct ListArgs {
    #[structopt(short, long)]
    pub ids: Option<Vec<u32>>,
    #[structopt(flatten)]
    pub paging_args: PagingArgs,
}

#[derive(Debug, StructOpt)]
pub(crate) struct CommonProjectArgs {
    #[structopt(short, long)]
    pub project: Option<String>,
    #[structopt(long)]
    pub project_id: Option<u32>,
}

#[derive(Debug, StructOpt)]
pub(crate) struct CommonLabelArgs {
    #[structopt(short, long)]
    pub labels: Option<Vec<String>>,
    #[structopt(long)]
    pub label_ids: Option<Vec<u32>>,
}

#[derive(Debug, StructOpt)]
pub(crate) struct PriorityArgs {
    #[structopt(long, default_value = "1")]
    pub priority: u8,
}

#[derive(Debug, StructOpt)]
pub(crate) struct DeleteArgs {
    #[structopt(short, long)]
    pub id: u32,
}
