mod todoist;
mod web;

use structopt::StructOpt;
use todoist::Todoist;

/**
Our application works like this:
1.  User invokes the app, args are parsed.
2.  We match on the `command` and `subcommand` args so we know what the user wants to do.
3.  Once we know what the user wants to achieve, we start mapping, making API calls, and piece it
    all together.
4.  Then we return some info.
*/
fn main() {
    // Exits if we get garbage in, thanks StructOpt & Clap.
    let cmd = Command::from_args();

    // Begin the deep dive; down the rabbit hole.
    match cmd {
        Command::Todoist { todoist } => Todoist::run(todoist),
    }
}

/**
Add all commands here. Rule of thumb is defining a struct means you're defining a new application;
so a new module, or command; variants (or subcommands) on that module are then defined as enums,
which we're calling an Opt. Option? Operation? Idk.
*/
#[derive(Debug, StructOpt)]
enum Command {
    Todoist {
        #[structopt(subcommand)]
        todoist: Todoist,
    },
}

/**
Command or application structs implement Runs of type `T`. Will probably expand this to include
logging options? Basically, this is the application level code, and the intent with this crate is
to be a meeting place for CLI apps.
*/
pub trait Runs<T> {
    fn run(args: T);
}
