# clogi

The name `clogi` was originally meant to mean `cargo-logistics`, since I had
wanted to create a command line utility that would cater to my abstract, object
oriented brain so I could run things like `cargo new class` within a project
and dump a lot of boiler plate code into files and organise them sensibly.

Now, it's more like `command-line-logistics`, since this project is basically
a meeting place for command line applications that I want to write.

I haven't finished developing it yet, but they say documenting is a good way of
scoping out a project, so here I am taking a few minutes (that will eventually
turn into hours as I review and edit minute details like the back-tics
surrounding the name `clogi` and `cargo-logistics` for absolutely no f\*\*\*ing
reason and replace them with single quotes, only to revert back days later once
I've forgotten why I cared in the first place.)

Anyway, rant over, document begins:

## Summer of parts

- [StructOpt](https://docs.rs/structopt/): automatic parsing of arguments, makes it easy to throw together new `Command`, `SubCommand`
- [Serde](https://docs.serde.rs/serde/): 99% of any application is modelling, serializing and mapping when you are abstracting away the details so you never have to do it again. The data you throw around changes a lot. Serde, or SerDe, is not that pleasant to use, it's not easy, it's pretty complicated shit; it does a lot of the hard work, so I appreciate it.
- [reqwest](https://docs.rs/reqwest/): for HTTP stuff.

## Credit, ideas & inspiration

- This [blog post](https://plume.benboeckel.net/~/JustAnotherBlog/designing-rust-bindings-for-rest-ap-is) from [Ben Boeckel](https://plume.benboeckel.net/@/ben.boeckel)

## main.rs

User invokes the program via `clogi <command> <subcommand>`; e.g. `clogi todoist task list --project_name "everyday"`.

So we've established that `clogi` wraps everything, `todoist` is an app within, `task` is a model, and `list` is an operation. That's how `clogi` is structured.

`main()` will parse args, and exit if it's not happy.

We then match on the `<command>`, and head into the application specific code, which lives in `todoist.rs`. All related functionality is contained in the `todoist` folder.

Within we have a StructOpt enum, `subcommand`. Here we say we're going to do stuff with some model.

### !! TODO: Our models are then going to support a number of different HTTP operations... !!
