pub use fake::FakeClock;

use std::time::SystemTime;

mod fake;

/// Simple clock.
#[derive(Debug, Clone)]
pub enum Clock {
    System,
    Fake(FakeClock),
}

impl Default for Clock {
    fn default() -> Self {
        Self::System
    }
}

impl Clock {
    /// Returns the time corresponding to "now".
    pub fn now(&self) -> SystemTime {
        match self {
            Self::System => SystemTime::now(),
            Self::Fake(inner) => inner.now(),
        }
    }
}

impl From<FakeClock> for Clock {
    fn from(value: FakeClock) -> Self {
        Self::Fake(value)
    }
}
