let
  rust-overlay = builtins.fetchurl {
    url = "https://git.sr.ht/~asym/dotfiles/blob/"
      + "5c2462b534a5e651c07b1dd4db277c6958e23c30/nixpkgs/overlays/rust.nix";
    sha256 = "sha256:0gcnjsc1x2vnf7iplv5hvzgnq5p471b264lyc857bacgwp4s13s4";
  };
  pkgs = import <nixpkgs> { overlays = [ (import rust-overlay) ]; };
in with pkgs;
mkShell {
  buildInputs = [ rust-channels.stable.rust cargo-edit rust-analyzer ]
    ++ lib.optionals stdenv.isDarwin [ libiconv ];

  shellHook = ''
    export RUST_SRC_PATH="${rustPlatform.rustLibSrc}";
  '';
}
