#![feature(map_first_last)]
use std::env;
use std::string::String;

use build::build_project;
use clap::{crate_authors, crate_description, crate_version, App, SubCommand};
use config::{parse_config, write_new_config};
use git::fetch_dependencies;

mod build;
mod config;
mod git;

fn main() -> Result<(), String> {
    let matches = App::new("Clean LL Make")
        .version(crate_version!())
        .author(crate_authors!())
        .about(crate_description!())
        .subcommand(SubCommand::with_name("init"))
        .subcommand(SubCommand::with_name("build"))
        .get_matches();

    match matches.subcommand_name() {
        Some("build") => {
            let config = parse_config();
            let mut paths = fetch_dependencies(&config);
            for path in config.paths {
                paths.push(path);
            }
            build_project(paths, config.main_module, config.name);
            Ok(())
        }
        Some("init") => {
            write_new_config();
            Ok(())
        }
        None => Err(String::from(
            "No subcommand given, use either init or build",
        )),
        _ => unreachable!(),
    }
}
