use crate::entities::cli::use_case::{CliUseCaseMeta, RawUseCaseRequest};
use crate::entities::errors::UseCaseError;
use crate::proto::cli::{ICliUseCase, ICliUseCaseWrapped};

pub struct UseCaseWrapper<UC> {
    use_case: UC,
}

impl<UC: ICliUseCase<Response = ()>> UseCaseWrapper<UC> {
    pub fn new(use_case: UC) -> UseCaseWrapper<UC> {
        UseCaseWrapper { use_case }
    }
}

impl<UC: ICliUseCase<Response = ()>> ICliUseCaseWrapped for UseCaseWrapper<UC> {
    fn get_meta(&self) -> CliUseCaseMeta {
        self.use_case.get_meta()
    }

    fn execute(&mut self, request: RawUseCaseRequest) -> Result<(), UseCaseError> {
        let validated = self.use_case.validate_request(request);
        self.use_case.execute(validated)
    }
}
