use crate::entities::di::config::{build_config, render_config};
use crate::entities::errors::UseCaseError;
use crate::entities::ConfigError;

pub use crate::entities::di::config::{ConfigFieldSchema, ConfigFieldState};

pub trait IConfig: Default + 'static + Sized {
    fn schema() -> Vec<ConfigFieldSchema<Self>>;

    fn all_fields(&self) -> Vec<ConfigFieldState> {
        render_config(self, &Self::schema())
    }

    fn build() -> Result<Self, ConfigError> {
        let mut result = Self::default();
        build_config(&mut result, &Self::schema())?;
        Ok(result)
    }
}

pub trait IUseCase {
    type Request;
    type Response;
    fn execute(&mut self, request: Self::Request) -> Result<Self::Response, UseCaseError>;
}

pub trait IRequestEnum: Sized + Copy + 'static {
    const ALL: &'static [(&'static str, Self)];

    fn keys() -> Vec<&'static str> {
        Self::ALL.iter().map(|(k, _)| *k).collect()
    }
    fn parse(text: &str) -> Option<Self> {
        for (key, item) in Self::ALL {
            if text == *key {
                return Some(*item);
            }
        }
        None
    }
    fn show_all() -> String {
        let keys = Self::ALL
            .iter()
            .map(|(k, _)| *k)
            .collect::<Vec<&'static str>>();
        format!("{:?}", keys)
    }
}
