use crate::entities::cli::use_case::{ArgParseResult, CliUseCaseMeta, RawUseCaseRequest};
use crate::entities::errors::UseCaseError;
use crate::proto::di::IUseCase;

pub trait IParamValidator {
    fn validate(&self, param: String) -> ArgParseResult;
}

impl IParamValidator for Box<dyn Fn(String) -> ArgParseResult> {
    fn validate(&self, param: String) -> ArgParseResult {
        self(param)
    }
}

pub trait ICliUseCase: IUseCase {
    fn get_meta(&self) -> CliUseCaseMeta;
    fn validate_request(&self, raw: RawUseCaseRequest) -> Self::Request;
}

pub(crate) trait ICliUseCaseWrapped {
    fn get_meta(&self) -> CliUseCaseMeta;
    fn execute(&mut self, request: RawUseCaseRequest) -> Result<(), UseCaseError>;
}
