import subprocess as sp
from filecmp import dircmp


def shell(
    command: str,
    expect_error: bool = False,
) -> str:
    command = f"{command} 2>&1"
    proc = sp.Popen(
        ["/bin/sh", "-c", command],
        stdout=sp.PIPE,
        bufsize=-1
    )
    output, _ = proc.communicate()
    if not expect_error and proc.returncode != 0:
        raise Exception("process failed")
    if expect_error and proc.returncode == 0:
        raise Exception("process succeed when fail expected")
    return output.decode().strip().split('\n')


def same_files(a: str, b: str) -> None:
    assert open(a, "rb").read() == open(b, "rb").read()


def diff_files(a: str, b: str) -> None:
    assert open(a, "rb").read() != open(b, "rb").read()


def equal_dirs(dir_a: str, dir_b: str):
    diff = dircmp(dir_a, dir_b)
    ok = True
    if diff.left_only:
        print("LEFT ONLY:", diff.left_only)
        ok = False
    if diff.right_only:
        print("RIGHT ONLY:", diff.right_only)
        ok = False
    if diff.diff_files:
        print("DIFF FILES:", diff.diff_files)
        ok = False
    assert ok
