use std::time::Duration;

use serde::{Deserialize, Serialize};

use clickhouse::{error::Result, sql, Client, Row};

async fn watch(client: &Client) -> Result<()> {
    let mut cursor = client
        .watch("SELECT * FROM test WHERE a IN (SELECT a FROM test_subs)")
        //.watch("lv_06af25b863c4910e78f82da8abe2f79164684a23")
        .only_events()
        .fetch()?;

    while let Some(v) = cursor.next().await? {
        println!("{:?} {}", std::time::SystemTime::now(), v);
    }

    Ok(())
}

#[tokio::main]
async fn main() -> Result<()> {
    let client = Client::default()
        .with_url("http://localhost:8123")
        .with_option("max_execution_time", "0");
    //.with_url("http://plt-clickhouse-1-ms.mgt:8123")
    //.with_database("square")
    //.with_user("ppavelko")
    //.with_password("e72afa8aabda87f301f64df3ca385902c96acf22f55715ba415e8d7375839203");

    println!("START {:?}", std::time::SystemTime::now());

    let r = watch(&client).await;

    println!("END {:?}", std::time::SystemTime::now());

    r?;

    Ok(())
}
