use libxdo::XDo;
use clap::{App, Arg};

use std::error::Error;
use std::thread::sleep;
use std::time::Duration;

fn main() -> Result<(), Box<dyn Error>> {
    let matches = App::new("Clicker-xdo")
        .version("0.2.2")
        .author("poly000 <pedajilao@vip.qq.com>")
        .about("automatic clicker tool for *nix, based on xdo.")
        .arg(
            Arg::with_name("times")
                .help("times to click")
                .required(true)
                .short("t")
                .long("times")
                .takes_value(true),
        )
        .arg(
            Arg::with_name("offset")
                .help("offset between clicks (ms)")
                .required(true)
                .short("o")
                .long("offset")
                .takes_value(true),
        )
        .get_matches();

    let times = matches
        .value_of("times")
        .ok_or("illegal format of 'times', you should provide a integer.")?
        .parse()?;
    let offset = Duration::from_millis(
        matches
            .value_of("offset")
            .ok_or("illegal format of 'offset', you should provide a integer.")?
            .parse()?,
    );
    let xdo = XDo::new(None).unwrap();

    for _ in 0_u64..times {
        xdo.click(1).unwrap(); // click left button
        if !offset.is_zero() {
            sleep(offset);
        }
    }

    Ok(())
}
