use libxdo::XDo;

use std::env;
use std::thread::sleep;
use std::time::Duration;

fn main() {
    let xdo = XDo::new(None).unwrap();

    let times: u32 = env::args()
        .nth(1)
        .expect("No times was given!")
        .parse()
        .expect("<current>: Incorrect number type!");

    let offset: u64 = env::args()
        .nth(2)
        .expect("No offset was given!")
        .parse()
        .expect("<offset>: Incorrect number type!");

    for _ in 0..times {
        xdo.click(1).unwrap();
        sleep(Duration::from_millis(offset));
    }
}
