pub enum Style { ResetAll, Bold, Dim, Italic, Underline, Blink, Inverted, Password, Strike }
pub enum Color { Black, Red, Green, Yellow, Blue, Magenta, Cyan, White, Default }

impl Color {
    pub fn fg(clr: Color) -> String {
        match clr {
            Color::Black   => String::from("\x1b[30m"),
            Color::Red     => String::from("\x1b[31m"),
            Color::Green   => String::from("\x1b[32m"),
            Color::Yellow  => String::from("\x1b[33m"),
            Color::Blue    => String::from("\x1b[34m"),
            Color::Magenta => String::from("\x1b[35m"),
            Color::Cyan    => String::from("\x1b[36m"),
            Color::White   => String::from("\x1b[37m"),
            Color::Default => String::from("\x1b[39m"),
        }
    }

    pub fn bg(clr: Color) -> String {
        match clr {
            Color::Black   => String::from("\x1b[40m"),
            Color::Red     => String::from("\x1b[41m"),
            Color::Green   => String::from("\x1b[42m"),
            Color::Yellow  => String::from("\x1b[43m"),
            Color::Blue    => String::from("\x1b[44m"),
            Color::Magenta => String::from("\x1b[45m"),
            Color::Cyan    => String::from("\x1b[46m"),
            Color::White   => String::from("\x1b[47m"),
            Color::Default => String::from("\x1b[49m"),
        }
    }
}

impl std::fmt::Display for Style {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Style::ResetAll  => write!(f, "\x1b[0m"),
            Style::Bold      => write!(f, "\x1b[1m"),
            Style::Dim       => write!(f, "\x1b[2m"),
            Style::Italic    => write!(f, "\x1b[3m"),
            Style::Underline => write!(f, "\x1b[4m"),
            Style::Blink     => write!(f, "\x1b[5m"),
            Style::Inverted  => write!(f, "\x1b[7m"),
            Style::Password  => write!(f, "\x1b[8m"),
            Style::Strike    => write!(f, "\x1b[9m"),
        }
    }
}