pub mod style;
pub mod gui;
pub mod cursor;

#[derive(Debug)]
pub struct CLInput {
    pub all: Vec<String>,
    pub args: Vec<String>,
    pub params: Vec<char>,
    pub sub_cmds: Vec<String>
}

impl CLInput {
    pub fn grab() -> CLInput {
        let mut all: Vec<String> = std::env::args().collect();
        let mut args: Vec<String> = Vec::new();
        let mut params: Vec<char> = Vec::new();
        let mut sub_cmds: Vec<String> = Vec::new();

        for (i, arg) in all.iter_mut().enumerate() {
            if i > 0 {
                if arg.starts_with("--") { arg.remove(0); arg.remove(0); sub_cmds.push(arg.clone()); }
                else if arg.starts_with("-") {
                    for ch in arg.chars() { if ch != '-' { params.push(ch); } }
                } else { args.push(arg.clone()); }
            }
        }

        CLInput { all, args, params, sub_cmds }
    }
}