use crate::Address;
use num256::Uint256;
use std::str::FromStr;

lazy_static! {
    pub static ref TT256 : Uint256 = Uint256::from_str("115792089237316195423570985008687907853269984665640564039457584007913129639936").unwrap(); // 2 ** 256
    pub static ref TT256M1 : Uint256 = Uint256::from_str("115792089237316195423570985008687907853269984665640564039457584007913129639935").unwrap(); // 2 ** 256 - 1
    pub static ref TT255 : Uint256= Uint256::from_str("57896044618658097711785492504343953926634992332820282019728792003956564819968").unwrap(); //2 ** 255
    pub static ref SECP256K1P : Uint256 = Uint256::from_str("115792089237316195423570985008687907853269984665640564039457584007908834671663").unwrap(); // 2**256 - 4294968273
    pub static ref SECPK1N : Uint256 = Uint256::from_str("115792089237316195423570985008687907852837564279074904382605163141518161494337").unwrap();
    pub static ref ZERO_ADDRESS: Address = "0x0000000000000000000000000000000000000000".parse().unwrap();
}
