use tokio::time::{sleep, Duration};
use tokio::{self};
use chrono::{Utc};
use futures::future::{self, try_join_all};

async fn data() {
	loop{
			 let now = Utc::now();
			 println!("DATA | {} |  function executed", now);
			 sleep(Duration::from_secs(10)).await;
		}
}


async fn serve() {
	loop {
			  let now = Utc::now();
			  println!("SERVE | {} | function executed", now);
			  sleep(Duration::from_secs(8)).await;
		}
}


/*
This function tend to understand how operate in general, withouth
calling the real functions, create two task to run asyncronously

*/
pub async fn datagen_server(
	_scheme: &String,
	_host: &String,
	_port: &u16,
	_protocol: &String, 
	_version: &String,
	_equipment_name: &String,
	_equipment_serie: &u16,
	_end_flag: &String
) {

	println!("Starting datagen_server");
	let data_task = tokio::spawn(async move {
		data().await;
	});
	let serve_task = tokio::spawn(async move {
		serve().await;
	});

	let v = vec![data_task, serve_task];

	let outputs = future::try_join_all(v).await;

}
