# CKB Release Integrity Check

All the binaries available from GitHub releases are signed via following PGP keys.

| Version   | Package              | Unique ID                              | OpenPGP Key                                                                          | Fingerprint                                        |
| --------- | -------------------- | -------------------------------------- | ------------------------------------------------------------------------------------ | -------------------------------------------------- |
| >= 0.13.0, < 0.43.0 | macOS, Linux, CentOS | Nervos Travis Builder <bot@nervos.org> | [F4631C0A](https://keyserver.ubuntu.com/pks/lookup?op=get&search=0x4F37F694F4631C0A) | 64B7 05B5 6078 1FC5 4047  7B82 4F37 F694 F463 1C0A |
| >= 0.14.0, < 0.43.0 | Windows              | Nervos Azure Builder <bot@nervos.org>  | [AD748F26](https://keyserver.ubuntu.com/pks/lookup?op=get&search=0x5EBA64ECAD748F26) | 0849 A2D2 4CA7 CFFC FA80  BCD4 5EBA 64EC AD74 8F26 |
| >= 0.43.0 | macOS, Linux, CentOS, Windows  | Nervos CI <bot@nervos.org>             | [34FF2E93](https://keys.openpgp.org/vks/v1/by-fingerprint/8D09AC56856F84AFDB2CEB12E21C4F2E34FF2E93) | 8D09 AC56 856F 84AF DB2C  EB12 E21C 4F2E 34FF 2E93 |


You can import the public keys from the keyserver network:

```
gpg --recv-keys E21C4F2E34FF2E93
```

Once you have already imported the public keys, please download both the archive and
the corresponding `.asc` file to verify the signature. For example, to check
the signature of the file `ckb_v0.43.0_x86_64-apple-darwin.zip`

```
gpg --verify ckb_v0.43.0_x86_64-apple-darwin.zip.asc ckb_v0.43.0_x86_64-apple-darwin.zip
```

Note: you should never use a GnuPG version you just downloaded to check the integrity of the source — use an existing, trusted GnuPG installation, e.g., the one provided by your distribution.

If the output of the above command is similar to the following, then either you don't have our public keys or the signature was generated by someone else and the file should be treated suspiciously.

```
gpg: Signature made Wed 05 Jun 2019 10:12:22 PM UTC using RSA key ID F4631C0A
gpg: Can't check signature: No public key
```

If you instead see:

```
gpg: Signature made Wed 05 Jun 2019 10:12:22 PM UTC using RSA key ID F4631C0A
gpg: Good signature from "Nervos CI <bot@nervos.org>"
gpg: WARNING: This key is not certified with a trusted signature!
gpg:          There is no indication that the signature belongs to the owner.
Primary key fingerprint: 64B7 05B5 6078 1FC5 4047  7B82 4F37 F694 F463 1C0A
```

then you have a copy of our keys and the signatures are valid, but either you have not marked the keys as trusted or the keys are a forgery. In this case, at the very least, you should compare the fingerprints that are shown above.

Ideally, you'll see something like:

```
gpg: Signature made Wed 05 Jun 2019 10:12:22 PM UTC using RSA key ID F4631C0A
gpg: checking the trustdb
gpg: 3 marginal(s) needed, 1 complete(s) needed, PGP trust model
gpg: depth: 0  valid:   1  signed:   0  trust: 0-, 0q, 0n, 0m, 0f, 1u
gpg: next trustdb check due at 2023-06-05
gpg: Good signature from "Nervos CI <bot@nervos.org>"
```
