#define CKB_VM_ASM_GENERATE_LABEL_TABLES 1
#include "cdefinitions_generated.h"

#define INT64_MIN 0x8000000000000000
#define UINT64_MAX 0xffffffffffffffff

#define MACHINE x0

#define TEMP1 x8
#define TEMP1w w8
#define TEMP2 x9
#define TEMP2w w9
#define TEMP3 x10
#define TEMP3w w10
#define TEMP4 x11
#define TEMP4w w11
#define TEMP5 x12
#define TEMP5w w12
#define TRACE x13
#define INST_PC x14
#define INST_ARGS x15

#define RD x16
#define RS1 x17
#define RS1w w17
#define RS2 x18
#define RS2w w18
#define RS3 x19
#define RS3w w19
#define IMMEDIATE x20
#define IMMEDIATEw w20
#define FLAG x21

#define REGISTER_BASE x22
#define ZERO_VALUE xzr

#ifdef __APPLE__
#define SEP %%
#else
#define SEP ;
#endif

#define PREPCALL \
  stp x0, x8, [sp, -96]! SEP \
  stp x9, x10, [sp, 16] SEP \
  stp x11, x12, [sp, 32] SEP \
  stp x13, x14, [sp, 48] SEP \
  stp x15, x16, [sp, 64] SEP \
  stp x17, x18, [sp, 80]

#define POSTCALL \
  ldp x17, x18, [sp, 80] SEP \
  ldp x15, x16, [sp, 64] SEP \
  ldp x13, x14, [sp, 48] SEP \
  ldp x11, x12, [sp, 32] SEP \
  ldp x9, x10, [sp, 16] SEP \
  ldp x0, x8, [sp], 96

#define REGISTER_ADDRESS(r) [REGISTER_BASE, r, lsl 3]
#define ZERO_ADDRESS [REGISTER_BASE]
#define RA_ADDRESS [MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_REGISTERS + CKB_VM_ASM_REGISTER_RA * 8]

#define PC_ADDRESS [MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_PC]
#define VERSION_ADDRESS [MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_VERSION]

#define LOAD_VERSION(r) \
  add r, MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_VERSION SEP \
  ldr r, [r]

#define WRITE_RD(v) \
  str v, REGISTER_ADDRESS(RD) SEP \
  str ZERO_VALUE, ZERO_ADDRESS

#define WRITE_RS1(v) \
  str v, REGISTER_ADDRESS(RS1) SEP \
  str ZERO_VALUE, ZERO_ADDRESS

#define WRITE_RS2(v) \
  str v, REGISTER_ADDRESS(RS2) SEP \
  str ZERO_VALUE, ZERO_ADDRESS

#define WRITE_RS3(v) \
  str v, REGISTER_ADDRESS(RS3) SEP \
  str ZERO_VALUE, ZERO_ADDRESS

#define NEXT_INST \
  ldr TEMP1, [INST_ARGS] SEP \
  add INST_ARGS, INST_ARGS, 8 SEP \
  ubfx RD, TEMP1, 8, 8 SEP \
  asr TEMP1, TEMP1, 24 SEP \
  ubfx FLAG, TEMP1, 0, 8 SEP \
  asr TEMP1, TEMP1, 8 SEP \
  ldr x9, [INST_PC] SEP \
  add INST_PC, INST_PC, 8 SEP \
  br x9

#define DECODE_R \
  ubfx RS1, TEMP1, 0, 8 SEP \
  ubfx RS2, TEMP1, 8, 8

#define DECODE_I \
  ubfx RS1, TEMP1, 0, 8 SEP \
  asr IMMEDIATE, TEMP1, 8

#define DECODE_S \
  mov RS2, RD SEP \
  ubfx RS1, TEMP1, 0, 8 SEP \
  asr IMMEDIATE, TEMP1, 8

#define DECODE_R4 \
  ubfx RS1, TEMP1, 0, 8 SEP \
  ubfx RS2, TEMP1, 8, 8 SEP \
  asr TEMP1, TEMP1, 16 SEP \
  ubfx RS3, TEMP1, 0, 8

#define DECODE_U \
  mov IMMEDIATE, TEMP1

#ifdef __APPLE__
#define CALL_INITED_MEMORY bl _inited_memory
#else
#define CALL_INITED_MEMORY bl inited_memory
#endif

#define CHECK_READ_BOUND_VERSION1(length) \
  ldr RS1, REGISTER_ADDRESS(RS1) SEP \
  add RS1, RS1, IMMEDIATE SEP \
  mov TEMP1, RS1 SEP \
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY SEP \
  bhs .exit_out_of_bound SEP \
  add TEMP1, TEMP1, length SEP \
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY SEP \
  bhi .exit_out_of_bound

#define CHECK_READ(address_reg, length) \
  mov TEMP1, address_reg SEP \
  lsr TEMP1, TEMP1, CKB_VM_ASM_MEMORY_FRAME_SHIFTS SEP \
  cmp TEMP1, CKB_VM_ASM_MEMORY_FRAMES SEP \
  bhs .exit_out_of_bound SEP \
  ldr TEMP4, =CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_FRAMES SEP \
  add TEMP5, TEMP1, TEMP4 SEP \
  ldrb TEMP2w, [MACHINE, TEMP5] SEP \
  cmp TEMP2, 0 SEP \
  bne 1f SEP \
  mov TEMP3, 1 SEP \
  strb TEMP3w, [MACHINE, TEMP5] SEP \
  PREPCALL SEP \
  mov x1, MACHINE SEP \
  mov x0, TEMP1 SEP \
  CALL_INITED_MEMORY SEP \
  POSTCALL SEP \
1: \
  mov TEMP1, address_reg SEP \
  add TEMP1, TEMP1, length SEP \
  sub TEMP1, TEMP1, 1 SEP \
  lsr TEMP1, TEMP1, CKB_VM_ASM_MEMORY_FRAME_SHIFTS SEP \
  cmp TEMP1, CKB_VM_ASM_MEMORY_FRAMES SEP \
  bhs .exit_out_of_bound SEP \
  add TEMP5, TEMP1, TEMP4 SEP \
  ldrb TEMP2w, [MACHINE, TEMP5] SEP \
  cmp TEMP2, 0 SEP \
  bne 2f SEP \
  strb TEMP3w, [MACHINE, TEMP5] SEP \
  PREPCALL SEP \
  mov x1, MACHINE SEP \
  mov x0, TEMP1 SEP \
  CALL_INITED_MEMORY SEP \
  POSTCALL SEP \
2:

#define CHECK_WRITE(address_reg, length) \
  mov TEMP1, address_reg SEP \
  lsr TEMP1, TEMP1, CKB_VM_ASM_RISCV_PAGE_SHIFTS SEP \
  cmp TEMP1, CKB_VM_ASM_RISCV_PAGES SEP \
  bhs .exit_out_of_bound SEP \
  add TEMP5, TEMP1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_FLAGS SEP \
  ldrb TEMP3w, [MACHINE, TEMP5] SEP \
  mov TEMP2, TEMP3 SEP \
  and TEMP3, TEMP3, CKB_VM_ASM_MEMORY_FLAG_WXORX_BIT SEP \
  cmp TEMP3, CKB_VM_ASM_MEMORY_FLAG_WRITABLE SEP \
  bne .exit_invalid_permission SEP \
  orr TEMP2, TEMP2, CKB_VM_ASM_MEMORY_FLAG_DIRTY SEP \
  strb TEMP2w, [MACHINE, TEMP5] SEP \
  mov TEMP2, TEMP1 SEP \
  lsr TEMP1, TEMP1, CKB_VM_ASM_MEMORY_FRAME_PAGE_SHIFTS SEP \
  ldr TEMP5, =CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_FRAMES SEP \
  add TEMP5, TEMP1, TEMP5 SEP \
  ldrb TEMP3w, [MACHINE, TEMP5] SEP \
  cmp TEMP3, 0 SEP \
  bne 1f SEP \
  mov TEMP4, 1 SEP \
  strb TEMP4w, [MACHINE, TEMP5] SEP \
  PREPCALL SEP \
  mov x1, MACHINE SEP \
  mov x0, TEMP1 SEP \
  CALL_INITED_MEMORY SEP \
  POSTCALL SEP \
1: \
  mov TEMP1, TEMP2 SEP \
  add TEMP1, TEMP1, 1 SEP \
  lsl TEMP1, TEMP1, CKB_VM_ASM_RISCV_PAGE_SHIFTS SEP \
  mov TEMP2, address_reg SEP \
  add TEMP2, TEMP2, length SEP \
  cmp TEMP2, TEMP1 SEP \
  bls 2f SEP \
  lsr TEMP1, TEMP1, CKB_VM_ASM_RISCV_PAGE_SHIFTS SEP \
  cmp TEMP1, CKB_VM_ASM_RISCV_PAGES SEP \
  bhs .exit_out_of_bound SEP \
  add TEMP5, TEMP1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_FLAGS SEP \
  ldrb TEMP3w, [MACHINE, TEMP5] SEP \
  mov TEMP2, TEMP3 SEP \
  and TEMP3, TEMP3, CKB_VM_ASM_MEMORY_FLAG_WXORX_BIT SEP \
  cmp TEMP3, CKB_VM_ASM_MEMORY_FLAG_WRITABLE SEP \
  bne .exit_invalid_permission SEP \
  orr TEMP2, TEMP2, CKB_VM_ASM_MEMORY_FLAG_DIRTY SEP \
  strb TEMP2w, [MACHINE, TEMP5] SEP \
  lsr TEMP1, TEMP1, CKB_VM_ASM_RISCV_PAGE_SHIFTS SEP \
  ldr TEMP5, =CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_FRAMES SEP \
  add TEMP5, TEMP1, TEMP5 SEP \
  ldrb TEMP3w, [MACHINE, TEMP5] SEP \
  cmp TEMP3, 0 SEP \
  bne 2f SEP \
  strb TEMP4w, [MACHINE, TEMP5] SEP \
  PREPCALL SEP \
  mov x1, MACHINE SEP \
  mov x0, TEMP1 SEP \
  CALL_INITED_MEMORY SEP \
  POSTCALL SEP \
2:

.p2align 3
#ifdef __APPLE__
.globl _ckb_vm_x64_execute
_ckb_vm_x64_execute:
#else
.globl ckb_vm_x64_execute
ckb_vm_x64_execute:
#endif
  stp x19, x20, [sp, -48]!
  stp x21, x22, [sp, 16]
  stp x23, x30, [sp, 32]
  add REGISTER_BASE, MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_REGISTERS

.CKB_VM_ASM_LABEL_OP_CUSTOM_TRACE_END:
.prepare_trace:
  ldr TEMP2, [MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_PC]
  mov TEMP3, TEMP2
  lsr TEMP2, TEMP2, 5
  and TEMP2, TEMP2, 8191
  mov TEMP1, CKB_VM_ASM_TRACE_STRUCT_SIZE
  mul TEMP2, TEMP2, TEMP1
  add TRACE, MACHINE, TEMP2
  ldr TEMP1, =CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_TRACES
  add TRACE, TRACE, TEMP1
  ldr TEMP4, [TRACE, CKB_VM_ASM_TRACE_OFFSET_ADDRESS]
  cmp TEMP4, TEMP3
  bne .exit_trace
  ldrb TEMP3w, [TRACE, CKB_VM_ASM_TRACE_OFFSET_LENGTH]
  cmp TEMP4, 0
  beq .exit_trace
  ldr TEMP2, [MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_CYCLES]
  ldr TEMP1, [TRACE, CKB_VM_ASM_TRACE_OFFSET_CYCLES]
  add TEMP2, TEMP2, TEMP1
  cmp TEMP2, TEMP1
  bcc .exit_cycles_overflow
  ldr TEMP1, [MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MAX_CYCLES]
  cmp TEMP2, TEMP1
  bhi .exit_max_cycles_exceeded
  str TEMP2, [MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_CYCLES]
  add TEMP3, TEMP3, TEMP4
  str TEMP3, [MACHINE, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_PC]
  add INST_ARGS, TRACE, CKB_VM_ASM_TRACE_OFFSET_INSTRUCTIONS
  add INST_PC, TRACE, CKB_VM_ASM_TRACE_OFFSET_THREAD
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ADDI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ADD:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  add RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ADDIW:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ADDW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  add RS1, RS1, RS2
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_AND:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  and RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ANDI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  and RS1, RS1, IMMEDIATE
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_AUIPC:
  DECODE_U
  ldr RS1, PC_ADDRESS
  sub RS1, RS1, 4
  add RS1, RS1, IMMEDIATE
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BEQ:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  beq .i_branch_success
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BGE:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  bge .i_branch_success
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BGEU:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  bhs .i_branch_success
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BLT:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  blt .i_branch_success
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BLTU:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  blo .i_branch_success
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BNE:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  bne .i_branch_success
  NEXT_INST
.i_branch_success:
  ldr RS1, PC_ADDRESS
  and FLAG, FLAG, 0xF
  lsl FLAG, FLAG, 1
  sub RS1, RS1, FLAG
  add RS1, RS1, IMMEDIATE
  str RS1, PC_ADDRESS
  b .prepare_trace
.CKB_VM_ASM_LABEL_OP_DIV:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS2, 0
  bne .div_branch2
  mov RS1, UINT64_MAX
  b .div_branch3
.div_branch2:
  sdiv RS1, RS1, RS2
.div_branch3:
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_DIVU:
  DECODE_R
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS2, 0
  bne .divu_branch1
  mov TEMP1, UINT64_MAX
  WRITE_RD(TEMP1)
  NEXT_INST
.divu_branch1:
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  udiv TEMP1, TEMP1, RS2
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_DIVUW:
  DECODE_R
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov RS2w, RS2w
  cmp RS2, 0
  bne .divuw_branch1
  mov TEMP1, UINT64_MAX
  WRITE_RD(TEMP1)
  NEXT_INST
.divuw_branch1:
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  mov TEMP1w, TEMP1w
  udiv TEMP1, TEMP1, RS2
  sxtw TEMP1, TEMP1w
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_DIVW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  sxtw RS1, RS1w
  ldr RS2, REGISTER_ADDRESS(RS2)
  sxtw RS2, RS2w
  cmp RS2, 0
  bne .divw_branch2
  mov RS1, UINT64_MAX
  b .divw_branch3
.divw_branch2:
  sdiv RS1, RS1, RS2
.divw_branch3:
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_EBREAK:
  DECODE_U
  mov x0, CKB_VM_ASM_RET_EBREAK
  b .exit
.CKB_VM_ASM_LABEL_OP_ECALL:
  DECODE_U
  mov x0, CKB_VM_ASM_RET_ECALL
  b .exit
.CKB_VM_ASM_LABEL_OP_FENCE:
.CKB_VM_ASM_LABEL_OP_FENCEI:
  DECODE_U
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_JAL:
  DECODE_U
  ldr RS1, PC_ADDRESS
  WRITE_RD(RS1)
  and FLAG, FLAG, 0xF
  lsl FLAG, FLAG, 1
  sub RS1, RS1, FLAG
  add RS1, RS1, IMMEDIATE
  str RS1, PC_ADDRESS
  b .prepare_trace
.CKB_VM_ASM_LABEL_OP_JALR:
  LOAD_VERSION(TEMP5)
  cmp TEMP5, 1
  bge .CKB_VM_ASM_LABEL_OP_JALR_VERSION1
  b .CKB_VM_ASM_LABEL_OP_JALR_VERSION0
.CKB_VM_ASM_LABEL_OP_JALR_VERSION0:
  DECODE_I
  ldr TEMP1, PC_ADDRESS
  WRITE_RD(TEMP1)
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  add TEMP1, TEMP1, IMMEDIATE
  and TEMP1, TEMP1, -2
  str TEMP1, PC_ADDRESS
  b .prepare_trace
.CKB_VM_ASM_LABEL_OP_JALR_VERSION1:
  DECODE_I
  ldr TEMP2, REGISTER_ADDRESS(RS1)
  ldr TEMP1, PC_ADDRESS
  WRITE_RD(TEMP1)
  add TEMP2, TEMP2, IMMEDIATE
  and TEMP2, TEMP2, -2
  str TEMP2, PC_ADDRESS
  b .prepare_trace
.CKB_VM_ASM_LABEL_OP_LB:
  LOAD_VERSION(TEMP5)
  cmp TEMP5, 1
  bge .CKB_VM_ASM_LABEL_OP_LB_VERSION1
  b .CKB_VM_ASM_LABEL_OP_LB_VERSION0
.CKB_VM_ASM_LABEL_OP_LB_VERSION0:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  mov TEMP1, RS1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  add TEMP1, TEMP1, 1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  CHECK_READ(RS1, 1)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrsb RS1, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LB_VERSION1:
  DECODE_I
  CHECK_READ_BOUND_VERSION1(1)
  CHECK_READ(RS1, 1)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrsb RS1, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LBU:
  LOAD_VERSION(TEMP5)
  cmp TEMP5, 1
  bge .CKB_VM_ASM_LABEL_OP_LBU_VERSION1
  b .CKB_VM_ASM_LABEL_OP_LBU_VERSION0
.CKB_VM_ASM_LABEL_OP_LBU_VERSION0:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  mov TEMP1, RS1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  add TEMP1, TEMP1, 1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  CHECK_READ(RS1, 1)  
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrb RS1w, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LBU_VERSION1:
  DECODE_I
  CHECK_READ_BOUND_VERSION1(1)
  CHECK_READ(RS1, 1)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrb RS1w, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LD:
  LOAD_VERSION(TEMP5)
  cmp TEMP5, 1
  bge .CKB_VM_ASM_LABEL_OP_LD_VERSION1
  b .CKB_VM_ASM_LABEL_OP_LD_VERSION0
.CKB_VM_ASM_LABEL_OP_LD_VERSION0:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  mov TEMP1, RS1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  add TEMP1, TEMP1, 8
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  CHECK_READ(RS1, 8)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldr RS1, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LD_VERSION1:
  DECODE_I
  CHECK_READ_BOUND_VERSION1(8)
  CHECK_READ(RS1, 8)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldr RS1, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LH:
  LOAD_VERSION(TEMP5)
  cmp TEMP5, 1
  bge .CKB_VM_ASM_LABEL_OP_LH_VERSION1
  b .CKB_VM_ASM_LABEL_OP_LH_VERSION0
.CKB_VM_ASM_LABEL_OP_LH_VERSION0:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  mov TEMP1, RS1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  add TEMP1, TEMP1, 2
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  CHECK_READ(RS1, 2)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrsh RS1, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LH_VERSION1:
  DECODE_I
  CHECK_READ_BOUND_VERSION1(2)
  CHECK_READ(RS1, 2)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrsh RS1, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LHU:
  LOAD_VERSION(TEMP5)
  cmp TEMP5, 1
  bge .CKB_VM_ASM_LABEL_OP_LHU_VERSION1
  b .CKB_VM_ASM_LABEL_OP_LHU_VERSION0
.CKB_VM_ASM_LABEL_OP_LHU_VERSION0:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  mov TEMP1, RS1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  add TEMP1, TEMP1, 2
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  CHECK_READ(RS1, 2)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrh RS1w, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LHU_VERSION1:
  DECODE_I
  CHECK_READ_BOUND_VERSION1(2)
  CHECK_READ(RS1, 2)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrh RS1w, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LUI:
.CKB_VM_ASM_LABEL_OP_CUSTOM_LOAD_IMM:
.CKB_VM_ASM_LABEL_OP_LD_SIGN_EXTENDED_32_CONSTANT:
  DECODE_U
  WRITE_RD(IMMEDIATE)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LW:
  LOAD_VERSION(TEMP5)
  cmp TEMP5, 1
  bge .CKB_VM_ASM_LABEL_OP_LW_VERSION1
  b .CKB_VM_ASM_LABEL_OP_LW_VERSION0
.CKB_VM_ASM_LABEL_OP_LW_VERSION0:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  mov TEMP1, RS1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  add TEMP1, TEMP1, 4
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  CHECK_READ(RS1, 4)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrsw RS1, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LW_VERSION1:
  DECODE_I
  CHECK_READ_BOUND_VERSION1(4)
  CHECK_READ(RS1, 4)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldrsw RS1, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LWU:
  LOAD_VERSION(TEMP5)
  cmp TEMP5, 1
  bge .CKB_VM_ASM_LABEL_OP_LWU_VERSION1
  b .CKB_VM_ASM_LABEL_OP_LWU_VERSION0
.CKB_VM_ASM_LABEL_OP_LWU_VERSION0:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  mov TEMP1, RS1
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  add TEMP1, TEMP1, 4
  cmp TEMP1, CKB_VM_ASM_RISCV_MAX_MEMORY
  bhs .exit_out_of_bound
  CHECK_READ(RS1, 4)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldr RS1w, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_LWU_VERSION1:
  DECODE_I
  CHECK_READ_BOUND_VERSION1(2)
  CHECK_READ(RS1, 2)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldr RS1w, [MACHINE, RS1]
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MUL:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mul RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MULH:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  smulh RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MULHSU:
  DECODE_R
  ldr TEMP2, REGISTER_ADDRESS(RS1)
  tst TEMP2, TEMP2
  bpl .mulhsu_branch1
  neg TEMP2, TEMP2
  ldr TEMP3, REGISTER_ADDRESS(RS2)
  umulh TEMP1, TEMP2, TEMP3
  mov TEMP4, -1
  eor TEMP1, TEMP1, TEMP4
  ldr TEMP2, REGISTER_ADDRESS(RS1)
  mul TEMP2, TEMP2, TEMP3
  tst TEMP2, TEMP2
  cset TEMP2, eq
  add TEMP1, TEMP1, TEMP2
  WRITE_RD(TEMP1)
  NEXT_INST
.mulhsu_branch1:
  ldr TEMP3, REGISTER_ADDRESS(RS2)
  umulh TEMP2, TEMP2, TEMP3
  WRITE_RD(TEMP2)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MULHU:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  umulh RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MULW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mul RS1, RS1, RS2
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_OR:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  orr RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ORI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  orr RS1, RS1, IMMEDIATE
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_REM:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS2, 0
  bne .rem_branch2
  b .rem_branch3
.rem_branch2:
  sdiv TEMP1, RS1, RS2
  msub RS1, TEMP1, RS2, RS1
.rem_branch3:
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_REMU:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS2, 0
  bne .remu_branch2
  WRITE_RD(RS1)
  NEXT_INST
.remu_branch2:
  udiv TEMP1, RS1, RS2
  msub TEMP2, TEMP1, RS2, RS1
  WRITE_RD(TEMP2)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_REMUW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov RS2w, RS2w
  cmp RS2, 0
  bne .remuw_branch2
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.remuw_branch2:
  mov RS1w, RS1w
  udiv TEMP1, RS1, RS2
  msub TEMP2, TEMP1, RS2, RS1
  sxtw TEMP2, TEMP2w
  WRITE_RD(TEMP2)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_REMW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  sxtw RS1, RS1w
  ldr RS2, REGISTER_ADDRESS(RS2)
  sxtw RS2, RS2w
  cmp RS2, 0
  bne .remw_branch2
  b .remw_branch3
.remw_branch2:
  sdiv TEMP1, RS1, RS2
  msub RS1, TEMP1, RS2, RS1
.remw_branch3:
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SB:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  CHECK_WRITE(RS1, 1)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldr RS2, REGISTER_ADDRESS(RS2)
  strb RS2w, [MACHINE, RS1]
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SD:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  CHECK_WRITE(RS1, 8)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldr RS2, REGISTER_ADDRESS(RS2)
  str RS2, [MACHINE, RS1]
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SH:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  CHECK_WRITE(RS1, 2)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldr RS2, REGISTER_ADDRESS(RS2)
  strh RS2w, [MACHINE, RS1]
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLL:
  DECODE_R
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  ldr TEMP2, REGISTER_ADDRESS(RS2)
  lsl TEMP1, TEMP1, TEMP2
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLLI:
  DECODE_I
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  lsl TEMP1, TEMP1, IMMEDIATE
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLLIW:
  DECODE_I
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  lsl TEMP1, TEMP1, IMMEDIATE
  sxtw TEMP1, TEMP1w
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLLW:
  DECODE_R
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  ldr TEMP2, REGISTER_ADDRESS(RS2)
  and TEMP2, TEMP2, 0x1F
  lsl TEMP1, TEMP1, TEMP2
  sxtw TEMP1, TEMP1w
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLT:
  DECODE_R
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  ldr TEMP2, REGISTER_ADDRESS(RS2)
  cmp TEMP1, TEMP2
  cset TEMP1, lt
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLTI:
  DECODE_I
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  cmp TEMP1, IMMEDIATE
  cset TEMP1, lt
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLTIU:
  DECODE_I
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  cmp TEMP1, IMMEDIATE
  cset TEMP1, lo
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLTU:
  DECODE_R
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  ldr TEMP2, REGISTER_ADDRESS(RS2)
  cmp TEMP1, TEMP2
  cset TEMP1, lo
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SRA:
  DECODE_R
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  ldr TEMP2, REGISTER_ADDRESS(RS2)
  asr TEMP1, TEMP1, TEMP2
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SRAI:
  DECODE_I
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  asr TEMP1, TEMP1, IMMEDIATE
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SRAIW:
  DECODE_I
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  asr TEMP1w, TEMP1w, IMMEDIATEw
  sxtw TEMP1, TEMP1w
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SRAW:
  DECODE_R
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  ldr TEMP2, REGISTER_ADDRESS(RS2)
  and TEMP2, TEMP2, 0x1F
  asr TEMP1w, TEMP1w, TEMP2w
  sxtw TEMP1, TEMP1w
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SRL:
  DECODE_R
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  ldr TEMP2, REGISTER_ADDRESS(RS2)
  lsr TEMP1, TEMP1, TEMP2
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SRLI:
  DECODE_I
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  lsr TEMP1, TEMP1, IMMEDIATE
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SRLIW:
  DECODE_I
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  lsr TEMP1w, TEMP1w, IMMEDIATEw
  sxtw TEMP1, TEMP1w
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SRLW:
  DECODE_R
  ldr TEMP1, REGISTER_ADDRESS(RS1)
  ldr TEMP2, REGISTER_ADDRESS(RS2)
  and TEMP2, TEMP2, 0x1F
  lsr TEMP1w, TEMP1w, TEMP2w
  sxtw TEMP1, TEMP1w
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SUB:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  sub RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SUBW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  sub RS1, RS1, RS2
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SW:
  DECODE_S
  ldr RS1, REGISTER_ADDRESS(RS1)
  add RS1, RS1, IMMEDIATE
  CHECK_WRITE(RS1, 4)
  add RS1, RS1, CKB_VM_ASM_ASM_CORE_MACHINE_OFFSET_MEMORY
  ldr RS2, REGISTER_ADDRESS(RS2)
  str RS2w, [MACHINE, RS1]
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_XOR:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  eor RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_XORI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  eor RS1, RS1, IMMEDIATE
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ADDUW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov RS1w, RS1w
  add RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ANDN:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mvn RS2, RS2
  and RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BCLR:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov TEMP1, 1
  lsl TEMP1, TEMP1, RS2
  mvn TEMP1, TEMP1
  and RS1, RS1, TEMP1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BCLRI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  mov TEMP1, 1
  lsl TEMP1, TEMP1, IMMEDIATE
  mvn TEMP1, TEMP1
  and RS1, RS1, TEMP1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BEXT:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  lsr RS1, RS1, RS2
  and RS1, RS1, 1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BEXTI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  lsr RS1, RS1, IMMEDIATE
  and RS1, RS1, 1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BINV:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov TEMP1, 1
  lsl TEMP1, TEMP1, RS2
  eor RS1, RS1, TEMP1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BINVI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  mov TEMP1, 1
  lsl TEMP1, TEMP1, IMMEDIATE
  eor RS1, RS1, TEMP1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BSET:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov TEMP1, 1
  lsl TEMP1, TEMP1, RS2
  orr RS1, RS1, TEMP1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_BSETI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  mov TEMP1, 1
  lsl TEMP1, TEMP1, IMMEDIATE
  orr RS1, RS1, TEMP1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CLMUL:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov TEMP4, 0
  mov TEMP3, 0
.clmul_branch:
  mov TEMP1, RS1
  mov TEMP2, RS2
  lsl TEMP1, TEMP1, TEMP4
  lsr TEMP2, TEMP2, TEMP4
  eor TEMP1, TEMP1, TEMP3
  and TEMP2, TEMP2, 1
  cmp TEMP2, 0
  csel TEMP3, TEMP1, TEMP3, ne
  add TEMP4, TEMP4, 1
  cmp TEMP4, 64
  bne .clmul_branch
  WRITE_RD(TEMP3)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CLMULH:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov RS3, 1
  mov TEMP3, 0
.clmulh_branch:
  mov TEMP1, RS1
  mov TEMP2, RS2
  mov TEMP4, 64
  sub TEMP4, TEMP4, RS3
  lsr TEMP1, TEMP1, TEMP4
  mov TEMP4, RS3
  lsr TEMP2, TEMP2, TEMP4
  eor TEMP1, TEMP1, TEMP3
  and TEMP2, TEMP2, 1
  cmp TEMP2, 0
  csel TEMP3, TEMP1, TEMP3, ne
  add RS3, RS3, 1
  cmp RS3, 64
  bne .clmulh_branch
  WRITE_RD(TEMP3)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CLMULR:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov RS3, 0
  mov TEMP3, 0
.clmulr_branch:
  mov TEMP1, RS1
  mov TEMP2, RS2
  mov TEMP4, 63
  sub TEMP4, TEMP4, RS3
  lsr TEMP1, TEMP1, TEMP4
  mov TEMP4, RS3
  lsr TEMP2, TEMP2, TEMP4
  eor TEMP1, TEMP1, TEMP3
  and TEMP2, TEMP2, 1
  cmp TEMP2, 0
  csel TEMP3, TEMP1, TEMP3, ne
  add RS3, RS3, 1
  cmp RS3, 64
  bne .clmulr_branch
  WRITE_RD(TEMP3)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CLZ:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  clz RS1, RS1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CLZW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  clz RS1w, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CPOP:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  mov RS2, RS1
  lsr RS2, RS2, 1
  ldr TEMP1, =0x5555555555555555
  and RS2, RS2, TEMP1
  sub RS1, RS1, RS2
  mov RS2, RS1
  ldr TEMP1, =0x3333333333333333
  and RS2, RS2, TEMP1
  lsr RS1, RS1, 2
  and RS1, RS1, TEMP1
  add RS1, RS1, RS2
  mov RS2, RS1
  lsr RS2, RS2, 4
  add RS1, RS1, RS2
  ldr TEMP1, =0x0f0f0f0f0f0f0f0f
  and RS1, RS1, TEMP1
  mov RS2, RS1
  lsr RS2, RS2, 8
  add RS1, RS1, RS2
  mov RS2, RS1
  lsr RS2, RS2, 16
  add RS1, RS1, RS2
  mov RS2, RS1
  lsr RS2, RS2, 32
  add RS1, RS1, RS2
  and RS1, RS1, 0x7f
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CPOPW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  mov RS2w, RS1w
  lsr RS2w, RS2w, 1
  and RS2w, RS2w, 0x55555555
  sub RS1w, RS1w, RS2w
  mov RS2w, RS1w
  and RS2w, RS2w, 0x33333333
  lsr RS1w, RS1w, 2
  and RS1w, RS1w, 0x33333333
  add RS1w, RS1w, RS2w
  mov RS2w, RS1w
  lsr RS2w, RS2w, 4
  add RS1w, RS1w, RS2w
  and RS1w, RS1w, 0x0f0f0f0f
  mov RS2w, RS1w
  lsr RS2w, RS2w, 8
  add RS1w, RS1w, RS2w
  mov RS2w, RS1w
  lsr RS2w, RS2w, 16
  add RS1w, RS1w, RS2w
  and RS1w, RS1w, 0x3f
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CTZ:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  rbit RS1, RS1
  clz RS1, RS1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_CTZW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  rbit RS1w, RS1w
  clz RS1w, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MAX:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  csel RS1, RS1, RS2, ge
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MAXU:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  csel RS1, RS1, RS2, hs
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MIN:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  csel RS1, RS1, RS2, le
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_MINU:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, RS2
  csel RS1, RS1, RS2, ls
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ORCB:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  mov RS2, 0
  ldr TEMP1, =0x00000000000000ff
  mov TEMP2, TEMP1
  and TEMP1, TEMP1, RS1
  cmp TEMP1, 0
  beq .orcb_branch1
  orr RS2, RS2, TEMP2
.orcb_branch1:
  ldr TEMP1, =0x000000000000ff00
  mov TEMP2, TEMP1
  and TEMP1, TEMP1, RS1
  cmp TEMP1, 0
  beq .orcb_branch2
  orr RS2, RS2, TEMP2
.orcb_branch2:
  ldr TEMP1, =0x0000000000ff0000
  mov TEMP2, TEMP1
  and TEMP1, TEMP1, RS1
  cmp TEMP1, 0
  beq .orcb_branch3
  orr RS2, RS2, TEMP2
.orcb_branch3:
  ldr TEMP1, =0x00000000ff000000
  mov TEMP2, TEMP1
  and TEMP1, TEMP1, RS1
  cmp TEMP1, 0
  beq .orcb_branch4
  orr RS2, RS2, TEMP2
.orcb_branch4:
  ldr TEMP1, =0x000000ff00000000
  mov TEMP2, TEMP1
  and TEMP1, TEMP1, RS1
  cmp TEMP1, 0
  beq .orcb_branch5
  orr RS2, RS2, TEMP2
.orcb_branch5:
  ldr TEMP1, =0x0000ff0000000000
  mov TEMP2, TEMP1
  and TEMP1, TEMP1, RS1
  cmp TEMP1, 0
  beq .orcb_branch6
  orr RS2, RS2, TEMP2
.orcb_branch6:
  ldr TEMP1, =0x00ff000000000000
  mov TEMP2, TEMP1
  and TEMP1, TEMP1, RS1
  cmp TEMP1, 0
  beq .orcb_branch7
  orr RS2, RS2, TEMP2
.orcb_branch7:
  ldr TEMP1, =0xff00000000000000
  mov TEMP2, TEMP1
  and TEMP1, TEMP1, RS1
  cmp TEMP1, 0
  beq .orcb_branch8
  orr RS2, RS2, TEMP2
.orcb_branch8:
  WRITE_RD(RS2)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ORN:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mvn RS2, RS2
  orr RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_REV8:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  rev RS1, RS1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ROL:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov TEMP1, 64
  sub TEMP1, TEMP1, RS2
  ror RS1, RS1, TEMP1
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ROLW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov TEMP1, 32
  sub TEMP1, TEMP1, RS2
  ror RS1w, RS1w, TEMP1w
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ROR:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  ror RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_RORI:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  ror RS1, RS1, IMMEDIATE
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_RORIW:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  ror RS1w, RS1w, IMMEDIATEw
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_RORW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  ror RS1w, RS1w, RS2w
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SEXTB:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  sxtb RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SEXTH:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  sxth RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SH1ADD:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  lsl RS1, RS1, 1
  add RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SH1ADDUW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov RS1w, RS1w
  lsl RS1, RS1, 1
  add RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SH2ADD:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  lsl RS1, RS1, 2
  add RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SH2ADDUW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov RS1w, RS1w
  lsl RS1, RS1, 2
  add RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SH3ADD:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  lsl RS1, RS1, 3
  add RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SH3ADDUW:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mov RS1w, RS1w
  lsl RS1, RS1, 3
  add RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SLLIUW:
  DECODE_I
  ldr RS1, REGISTER_ADDRESS(RS1)
  mov RS1w, RS1w
  and IMMEDIATE, IMMEDIATE, 0x3f
  lsl RS1, RS1, IMMEDIATE
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_XNOR:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mvn RS2, RS2
  eor RS1, RS1, RS2
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ZEXTH:
  DECODE_R
  ldr RS1, REGISTER_ADDRESS(RS1)
  lsl RS1w, RS1w, 16
  lsr RS1w, RS1w, 16
  sxtw RS1, RS1w
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_FAR_JUMP_ABS:
  DECODE_U
  mov RS2, IMMEDIATE
  ldr TEMP1, PC_ADDRESS
  str TEMP1, RA_ADDRESS
  and RS2, RS2, -2
  str RS2, PC_ADDRESS
  b .prepare_trace
.CKB_VM_ASM_LABEL_OP_FAR_JUMP_REL:
  DECODE_U
  ldr RS2, PC_ADDRESS
  and FLAG, FLAG, 0xF
  lsl FLAG, FLAG, 1
  sub RS2, RS2, FLAG
  add RS2, RS2, IMMEDIATE
  ldr TEMP1, PC_ADDRESS
  str TEMP1, RA_ADDRESS
  and RS2, RS2, -2
  str RS2, PC_ADDRESS
  b .prepare_trace
.CKB_VM_ASM_LABEL_OP_WIDE_MUL:
  DECODE_R4
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mul TEMP1, RS1, RS2
  smulh TEMP2, RS1, RS2
  WRITE_RS3(TEMP1)
  WRITE_RD(TEMP2)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_WIDE_MULU:
  DECODE_R4
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  mul TEMP1, RS1, RS2
  umulh TEMP2, RS1, RS2
  WRITE_RS3(TEMP1)
  WRITE_RD(TEMP2)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_WIDE_MULSU:
  DECODE_R4
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  tst RS1, RS1
  bpl .wide_mulsu_branch1
  neg TEMP3, RS1
  umulh TEMP1, TEMP3, RS2
  mov TEMP3, -1
  eor TEMP1, TEMP1, TEMP3
  mul TEMP2, RS1, RS2
  tst TEMP2, TEMP2
  cset TEMP3, eq
  add TEMP1, TEMP1, TEMP3
  WRITE_RS3(TEMP2)
  WRITE_RD(TEMP1)
  NEXT_INST
.wide_mulsu_branch1:
  mul TEMP1, RS1, RS2
  umulh TEMP2, RS1, RS2
  WRITE_RS3(TEMP1)
  WRITE_RD(TEMP2)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_WIDE_DIV:
  DECODE_R4
  mov TEMP2, INT64_MIN
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS1, TEMP2
  bne .wide_div_branch1
  cmp RS2, -1
  bne .wide_div_branch1
  mov TEMP1, 0
  b .wide_div_branch3
.wide_div_branch1:
  cmp RS2, 0
  bne .wide_div_branch2
  mov TEMP1, RS1
  mov RS1, UINT64_MAX
  b .wide_div_branch3
.wide_div_branch2:
  sdiv TEMP2, RS1, RS2
  msub TEMP1, TEMP2, RS2, RS1
  mov RS1, TEMP2
.wide_div_branch3:
  WRITE_RS3(TEMP1)
  WRITE_RD(RS1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_WIDE_DIVU:
  DECODE_R4
  ldr RS1, REGISTER_ADDRESS(RS1)
  ldr RS2, REGISTER_ADDRESS(RS2)
  cmp RS2, 0
  bne .wide_divu_branch1
  WRITE_RS3(RS1)
  mov TEMP1, UINT64_MAX
  WRITE_RD(TEMP1)
  NEXT_INST
.wide_divu_branch1:
  udiv TEMP1, RS1, RS2
  msub TEMP2, TEMP1, RS2, RS1
  WRITE_RS3(TEMP2)
  WRITE_RD(TEMP1)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_ADC:
  DECODE_R
  mov TEMP1, 0
  mov TEMP2, 0
  mov TEMP5, 0
  ldr TEMP3, REGISTER_ADDRESS(RD)
  ldr TEMP4, REGISTER_ADDRESS(RS1)
  adds TEMP3, TEMP3, TEMP4
  adc TEMP1, TEMP1, TEMP5
  ldr TEMP4, REGISTER_ADDRESS(RS2)
  adds TEMP3, TEMP3, TEMP4
  adc TEMP2, TEMP2, TEMP5
  orr TEMP1, TEMP1, TEMP2
  WRITE_RS1(TEMP1)
  WRITE_RS2(TEMP2)
  WRITE_RD(TEMP3)
  NEXT_INST
.CKB_VM_ASM_LABEL_OP_SBB:
  DECODE_R4
  mov TEMP1, 0
  mov TEMP2, 0
  mov TEMP5, 0
  ldr TEMP3, REGISTER_ADDRESS(RD)
  ldr TEMP4, REGISTER_ADDRESS(RS1)
  subs TEMP3, TEMP3, TEMP4
  adc TEMP1, TEMP1, TEMP5
  eor TEMP1, TEMP1, 1
  ldr TEMP4, REGISTER_ADDRESS(RS2)
  subs TEMP3, TEMP3, TEMP4
  adc TEMP2, TEMP2, TEMP5
  eor TEMP2, TEMP2, 1
  WRITE_RS2(TEMP2)
  WRITE_RS3(TEMP1)
  orr TEMP1, TEMP1, TEMP2
  WRITE_RS1(TEMP1)
  WRITE_RD(TEMP3)
  NEXT_INST
.exit_max_cycles_exceeded:
  mov x0, CKB_VM_ASM_RET_MAX_CYCLES_EXCEEDED
  b .exit
.exit_cycles_overflow:
  mov x0, CKB_VM_ASM_RET_CYCLES_OVERFLOW
  b .exit
.exit_out_of_bound:
  mov x0, CKB_VM_ASM_RET_OUT_OF_BOUND
  b .exit
.exit_invalid_permission:
  mov x0, CKB_VM_ASM_RET_INVALID_PERMISSION
  b .exit
.exit_trace:
.CKB_VM_ASM_LABEL_OP_UNLOADED:
  DECODE_U
  mov x0, CKB_VM_ASM_RET_DECODE_TRACE
  b .exit
.exit_slowpath:
  DECODE_U
  mov x0, CKB_VM_ASM_RET_SLOWPATH
  b .exit
.exit:
  ldp x23, x30, [sp, 32]
  ldp x21, x22, [sp, 16]
  ldp x19, x20, [sp], 48
  ret
