use crate::{H160, H256, H512, H520};

fn assert_str_0x(s: &str, s_0x: &str) {
    assert_eq!(s.len() + 2, s_0x.len());
    assert_eq!(&s_0x[..2], "0x");
    assert_eq!(s, &s_0x[2..]);
}

macro_rules! add_tests {
    ($test_name:ident, $type:ident, $input:literal,
     $debug_str:literal, $debug_alt_str:literal, $low_hex_str:literal $(,)?) => {
        #[test]
        fn $test_name() {
            let value = $type::from_trimmed_str($input).unwrap();
            {
                let debug_str = format!("{:?}", value);
                assert_eq!($debug_str, &debug_str);
            }
            {
                let low_hex_alt_str = format!("{:#x}", value);
                let low_hex_str = format!("{:x}", value);
                assert_str_0x(&low_hex_str, &low_hex_alt_str);
                assert_eq!($low_hex_str, &low_hex_str);
            }
            {
                let display_alt_str = format!("{:#}", value);
                let display_str = format!("{}", value);
                assert_str_0x(&display_str, &display_alt_str);
                assert_eq!($low_hex_str, &display_str);
            }
        }
    };
}

add_tests!(
    test_h160,
    H160,
    "1",
    "H160 ( [ \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x01 \
    ] )",
    "1",
    "0000000000000000000000000000000000000001",
);
add_tests!(
    test_h256,
    H256,
    "1",
    "H256 ( [ \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 \
    ] )",
    "1",
    "0000000000000000000000000000000000000000000000000000000000000001",
);
add_tests!(
    test_h512,
    H512,
    "1",
    "H512 ( [ \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 \
    ] )",
    "1",
    "0000000000000000000000000000000000000000000000000000000000000000\
     0000000000000000000000000000000000000000000000000000000000000001",
);
add_tests!(
    test_h520,
    H520,
    "1",
    "H520 ( [ \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x01 \
    ] )",
    "1",
    "0000000000000000000000000000000000000000000000000000000000000000\
     0000000000000000000000000000000000000000000000000000000000000000\
     01",
);
