<div align="center">
<h1>citron</h1>
Ditch your panel for some 
<a href="https://github.com/grtcdr/citron#screenshot">snazzy</a>
desktop notifications.
</div>

citron is:
- a non-intrusive alternative to status bars.
- on-demand, i.e. does not run in the background.
- working across different distributions, window managers and desktop
  environments.

It leverages the performance-tailored
[libmacchina](https://github.com/Macchina-CLI/libmacchina) crate to retrieve
your system information, and makes use of the
[notify-rust](https://github.com/hoodie/notify-rust) crate to send you that
data in the form of notifications.

## Features

citron can notify you about your:
- [x] Date
- [x] Uptime
- [x] Memory
- [x] Network
- [x] Battery
- [x] Backlight

## Usage

Set a keybinding to one or all of citron's functionalities (see `--help`),
and watch it do its __magic__ 🪄

Here's what this would look like on [sway](https://swaywm.org/):

```bash
bindsym $mod+Alt+d  exec citron -d # Date
bindsym $mod+Alt+u  exec citron -u # Uptime
bindsym $mod+Alt+b  exec citron -b # Battery
bindsym $mod+Alt+m  exec citron -m # Memory
bindsym $mod+Alt+l  exec citron -l # Backlight
bindsym $mod+Alt+n  exec citron -n -i wlan0 # Network
```

citron can also display icons, and in some cases, the icons are
[contextually-aware](#contextually-aware-icons). To get a feel for this
feature, append the following flags to one of your commands `-I -T
<icon-theme>`, e.g. `citron --date -IT Papirus`

- `-I` enables the usage of icons.
- `-T` takes the name of an icon theme.

Don't know what icon themes you have installed? Use the `-L` flag.

## Contextually-aware Icons

The battery and date notification are smart enough to change their
icon depending on the context.

_"Go explore them, I don't want to spoil all the fun."_

## Prerequisites

citron requires the following dependencies to be able to display its
notifications:

- libdbus
- any notification daemon, e.g. mako, dunst, etc.

## Installation

### [C](https://crates.io/crates/citron)argo

```
cargo install citron
```

### [P](https://pkgsrc.se/x11/citron)kgsrc

```
pkgin install citron
```

## Acknowledgements

- Thank you to [@0323pin](https://github.com/0323pin) for packaging and
  maintaining _citron_ on NetBSD.

## Screenshot

![citron preview](assets/preview.png)
