use bytesize::ByteSize;
use std::fmt;

pub struct MemoryFormatter {
    used: u64,
    total: u64,
    percentage: f64,
}

impl MemoryFormatter {
    pub fn new() -> Self {
        Self {
            used: 0,
            total: 0,
            percentage: 0f64,
        }
    }

    pub fn set_used(&mut self, amount: u64) {
        self.used = amount;
    }

    pub fn set_total(&mut self, amount: u64) {
        self.total = amount;
    }

    pub fn set_percentage(&mut self) {
        self.percentage = self.used as f64 / self.total as f64 * 100f64;
    }
}

impl fmt::Display for MemoryFormatter {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{} / {} ({:.1}%)",
            ByteSize::kb(self.used),
            ByteSize::kb(self.total),
            self.percentage
        )
    }
}
