use std::fmt;

pub struct BacklightFormatter {
    percentage: usize,
}

impl BacklightFormatter {
    pub fn new() -> Self {
        Self { percentage: 0 }
    }

    pub fn set_percentage(&mut self, p: usize) {
        self.percentage = p;
    }
}

impl fmt::Display for BacklightFormatter {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        return write!(f, "{}%", self.percentage);
    }
}
