use structopt::StructOpt;

#[derive(Debug, StructOpt, Default)]
#[structopt(setting = structopt::clap::AppSettings::ColoredHelp)]
pub struct Options {
    /// Notifies you about your system's uptime.
    #[structopt(
        long = "uptime",
        short = "u",
        help = "Send a notification with uptime information"
    )]
    pub uptime: bool,

    /// Notifies you about your system's date and time.
    #[structopt(
        long = "date",
        short = "d",
        help = "Send a notification with date information"
    )]
    pub date: bool,

    /// Notifies you about your system's battery percentage and status.
    #[structopt(
        long = "battery",
        short = "b",
        help = "Send a notification with battery information"
    )]
    pub battery: bool,

    /// Notifies you about your system's networking status.
    #[structopt(
        long = "network",
        short = "n",
        help = "Send a notification with network information"
    )]
    pub network: bool,

    /// Notifies you about your system's memory usage.
    #[structopt(
        long = "memory",
        short = "m",
        help = "Send a notification with memory information"
    )]
    pub memory: bool,

    /// Notifies you about your system's backlight.
    #[structopt(
        long = "backlight",
        short = "l",
        help = "Send a notification with backlight information"
    )]
    pub backlight: bool,

    /// Sets the timeout for all the notifiers, `Notifier::get_timeout()` converts this to seconds.
    #[structopt(
        long = "timeout",
        short = "t",
        help = "Specify how long (in seconds) notifications appear for"
    )]
    pub timeout: Option<u32>,

    /// Specify an interface for the network notifier.
    #[structopt(
        long = "interface",
        short = "i",
        help = "Specify the interface for the network notification"
    )]
    pub interface: Option<String>,

    /// Use railway time.
    #[structopt(
        long = "railway",
        short = "R",
        requires = "date",
        help = "Use railway time"
    )]
    pub railway: bool,

    /// Enables the use of icons.
    #[structopt(
        long = "icons",
        short = "I",
        help = "Enables the use of icons",
        requires = "icon-theme"
    )]
    pub icons: bool,

    /// Specify an icon theme.
    #[structopt(
        long = "icon-theme",
        short = "T",
        help = "Specify the name of an installed icon theme e.g. \"Adwaita\"",
        requires = "icons"
    )]
    pub icon_theme: Option<String>,

    /// Lists the available icon themes.
    #[structopt(
        long = "list-icon-themes",
        short = "L",
        help = "Returns a list of the available icon themes"
    )]
    pub list_icon_themes: bool,

    /// Provides debug information.
    #[structopt(long = "debug", short = "D", help = "Provides debug information")]
    pub debug: bool,

    /// Prints version information.
    #[structopt(long = "version", short = "V", help = "Prints version information")]
    pub version: bool,
}
