use crate::notifier::Notifier;
use libmacchina::traits::ReadoutError;
use notify_rust::error::Error;
use notify_rust::{Notification, NotificationHandle};

pub fn send(
    readout: Result<String, ReadoutError>,
    notifier: Notifier,
) -> Result<NotificationHandle, Error> {
    match readout {
        Ok(value) => Notification::new()
            .body(&value)
            .summary(&notifier.get_summary())
            .timeout(notifier.get_timeout())
            .show(),
        Err(err) => Notification::new()
            .body(&err.to_string())
            .summary(&notifier.get_summary())
            .timeout(notifier.get_timeout())
            .show(),
    }
}
