use notify_rust::Timeout;
use std::fmt;

pub struct Notifier {
    summary: Summary,
    timeout: u32,
}

impl Notifier {
    pub fn new() -> Notifier {
        Notifier {
            summary: Summary::Date,
            timeout: 5,
        }
    }

    pub fn set_summary(&mut self, k: Summary) {
        self.summary = k;
    }

    pub fn get_summary(&self) -> String {
        self.summary.to_string()
    }

    pub fn set_timeout(&mut self, t: u32) {
        self.timeout = t;
    }

    pub fn get_timeout(&self) -> Timeout {
        Timeout::Milliseconds(self.timeout * 1000)
    }
}

pub enum Summary {
    Date,
    Uptime,
    Memory,
    Battery,
    Network,
    Backlight,
}

impl fmt::Display for Summary {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match *self {
            Summary::Date => write!(f, "Date"),
            Summary::Uptime => write!(f, "Uptime"),
            Summary::Memory => write!(f, "Memory"),
            Summary::Battery => write!(f, "Battery"),
            Summary::Network => write!(f, "Network"),
            Summary::Backlight => write!(f, "Backlight"),
        }
    }
}
