use std::fs;

pub fn get_timezone() -> Option<String> {
    if let Ok(link) = fs::read_link("/etc/localtime") {
        if let Ok(timezone) = link.strip_prefix("../usr/share/zoneinfo/") {
            if let Some(str) = timezone.to_str() {
                return Some(str.to_string());
            }
        } else if let Ok(timezone) = link.strip_prefix("/usr/share/zoneinfo/") {
            if let Some(str) = timezone.to_str() {
                return Some(str.to_string());
            }
        }
    } else {
        let timezone = std::fs::read_to_string("/etc/timezone");
        if let Ok(str) = timezone {
            return Some(str);
        }
    }

    None
}
