use crate::goodies::Month;
use chrono::Weekday;
use std::fmt;

pub struct DateFormatter {
    hour: (bool, u32),
    minute: u32,
    day: u32,
    month: u32,
    weekday: Weekday,
}

impl DateFormatter {
    pub fn new() -> Self {
        Self {
            hour: (false, 0),
            weekday: Weekday::Mon,
            minute: 0,
            day: 0,
            month: 0,
        }
    }

    pub fn set_hour(&mut self, hh: (bool, u32)) {
        self.hour = (hh.0, hh.1);
    }

    pub fn set_minute(&mut self, mm: u32) {
        self.minute = mm;
    }

    pub fn set_day(&mut self, dd: u32) {
        self.day = dd;
    }

    pub fn set_month(&mut self, mm: u32) {
        self.month = mm;
    }

    pub fn set_weekday(&mut self, wk: Weekday) {
        self.weekday = wk;
    }

    fn get_hour(&self) -> u32 {
        self.hour.1
    }

    fn get_minute(&self) -> u32 {
        self.minute
    }

    fn get_weekday(&self) -> Weekday {
        self.weekday
    }

    fn get_day(&self) -> u32 {
        self.day
    }

    fn get_month(&self) -> Month {
        Month::from(self.month)
    }

    pub fn get_am_or_pm(&self) -> String {
        if self.hour.0 {
            String::from("PM")
        } else {
            String::from("AM")
        }
    }
}

impl fmt::Display for DateFormatter {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{}, {} {:02} at {:02}:{:02} {}",
            self.get_weekday(),
            self.get_month(),
            self.get_day(),
            self.get_hour(),
            self.get_minute(),
            self.get_am_or_pm()
        )
    }
}
