use std::fmt;

pub struct UptimeFormatter {
    days: u32,
    hours: u32,
    minutes: u32,
}

impl From<usize> for UptimeFormatter {
    fn from(seconds: usize) -> UptimeFormatter {
        let seconds = seconds as f32;
        let d = (seconds / 60.0 / 60.0 / 24.0).floor();
        let h = (seconds / 60.0 / 60.0 % 24.0).floor();
        let m = (seconds / 60.0 % 60.0).floor();

        UptimeFormatter {
            days: d as u32,
            hours: h as u32,
            minutes: m as u32,
        }
    }
}

impl fmt::Display for UptimeFormatter {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        let mut compiled: Vec<String> = vec![];

        match self.days {
            0 => (),
            1 => compiled.push("1 day".to_string()),
            d => compiled.push(format!("{} days", d)),
        }

        match self.hours {
            0 => (),
            1 => compiled.push("1 hour".to_string()),
            h => compiled.push(format!("{} hours", h)),
        }

        match self.minutes {
            0 => (),
            1 => compiled.push("1 minute".to_string()),
            m => compiled.push(format!("{} minutes", m)),
        }

        write!(f, "{}", compiled.join(", "))
    }
}
