use libmacchina::traits::BatteryState;
use std::fmt;

pub struct BatteryFormatter {
    percentage: u8,
    state: BatteryState,
}

impl BatteryFormatter {
    pub fn new() -> Self {
        Self {
            percentage: 0,
            state: BatteryState::Discharging,
        }
    }

    pub fn set_percentage(&mut self, p: u8) {
        self.percentage = p;
    }

    pub fn set_state(&mut self, s: BatteryState) {
        self.state = s;
    }
}

impl fmt::Display for BatteryFormatter {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        if self.percentage == 100 {
            return write!(f, "State: Full");
        }

        match self.state {
            BatteryState::Charging => {
                write!(f, "Percentage: {}%\nState: Charging", self.percentage)
            }
            BatteryState::Discharging => {
                write!(f, "Percentage: {}%\nState: Discharging", self.percentage)
            }
        }
    }
}
