# citron

_citron_ — ditch your panel for some snazzy desktop notifications.

It is:
- a non-intrusive alternative to panels.
- on-demand, i.e. does not run in the background.
- working across different distributions, window managers and desktop
  environments.

_citron_ leverages the performance-tailored
[libmacchina](https://github.com/Macchina-CLI/libmacchina) crate to retrieve
your system information, and makes use of the
[notify-rust](https://github.com/hoodie/notify-rust) crate to send you that
data in the form of notifications.

## Usage

Set a keybinding to one or all of _citron_'s functionalities (see `--help`),
and watch it do its _magic_ 🪄

Here's what this would look like on [sway](https://swaywm.org/):

```bash
bindsym $mod+Alt+d  exec citron -d -t 5 # Date
bindsym $mod+Alt+u  exec citron -u -t 5 # Uptime
bindsym $mod+Alt+b  exec citron -b -t 5 # Battery
bindsym $mod+Alt+m  exec citron -m -t 5 # Memory
bindsym $mod+Alt+l  exec citron -l -t 5 # Backlight
bindsym $mod+Alt+n  exec citron -n -t 5 -i wlan0 # Network
```

## Features

It can notify you about your:
- [x] Date
- [x] Uptime
- [x] Memory
- [x] Network
- [x] Battery
- [x] Backlight

## Prerequisities

_citron_ requires the following packages to display notifications:

- libdbus
- any notification daemon, e.g. mako, dunst, etc.

## Installation

### [Ca](https://crates.io/crates/citron)rgo

```
cargo install citron
```

### [Pk](https://pkgsrc.se/x11/citron)gsrc

```
pkgin install citron
```

## Acknowledgements

- Thank you to [@0323pin](https://github.com/0323pin) for packaging and
  maintaining _citron_ on NetBSD.

## Screenshot

![citron preview](assets/preview.png)
