use crate::goodies::Time;
use libmacchina::traits::ReadoutError;
use notify_rust::error::Error;
use notify_rust::Notification;
use notify_rust::NotificationHandle;
use notify_rust::Timeout;

pub fn uptime(
    timeout: u32,
    readout: Result<Time, ReadoutError>,
) -> Result<NotificationHandle, Error> {
    const SUMMARY: &str = "Uptime";
    match readout {
        Ok(value) => Notification::new()
            .summary(SUMMARY)
            .body(&value.to_string())
            .timeout(Timeout::Milliseconds(timeout))
            .show(),
        Err(err) => Notification::new()
            .summary(SUMMARY)
            .body(&err.to_string())
            .timeout(Timeout::Milliseconds(timeout))
            .show(),
    }
}

pub fn memory(
    timeout: u32,
    readout: Result<String, ReadoutError>,
) -> Result<NotificationHandle, Error> {
    const SUMMARY: &str = "Memory";
    match readout {
        Ok(value) => Notification::new()
            .summary(SUMMARY)
            .body(&value.to_string())
            .timeout(Timeout::Milliseconds(timeout))
            .show(),
        Err(err) => Notification::new()
            .summary(SUMMARY)
            .body(&err.to_string())
            .timeout(Timeout::Milliseconds(timeout))
            .show(),
    }
}

pub fn network(
    timeout: u32,
    readout: Result<String, ReadoutError>,
) -> Result<NotificationHandle, Error> {
    const SUMMARY: &str = "Network";
    match readout {
        Ok(value) => Notification::new()
            .summary(SUMMARY)
            .body(&value.to_string())
            .timeout(Timeout::Milliseconds(timeout))
            .show(),
        Err(err) => Notification::new()
            .summary(SUMMARY)
            .body(&err.to_string())
            .timeout(Timeout::Milliseconds(timeout))
            .show(),
    }
}

pub fn battery(
    timeout: u32,
    readout: Result<String, ReadoutError>,
) -> Result<NotificationHandle, Error> {
    const SUMMARY: &str = "Battery";
    match readout {
        Ok(value) => Notification::new()
            .summary(SUMMARY)
            .body(&value.to_string())
            .timeout(Timeout::Milliseconds(timeout))
            .show(),
        Err(err) => Notification::new()
            .summary(SUMMARY)
            .body(&err.to_string())
            .timeout(Timeout::Milliseconds(timeout))
            .show(),
    }
}

pub fn date_time(
    timeout: u32,
    readout: Result<String, ReadoutError>,
) -> Result<NotificationHandle, Error> {
    const SUMMARY: &str = "Date";
    Notification::new()
        .summary(SUMMARY)
        .body(&readout.unwrap())
        .timeout(Timeout::Milliseconds(timeout))
        .show()
}
