#![allow(unused_must_use)]

mod cli;
mod goodies;
mod read;
mod send;

use structopt::StructOpt;

fn main() {
    let opt = cli::Opt::from_args();

    if opt.uptime {
        send::uptime(opt.get_timeout(), read::uptime());
        return;
    }

    if opt.date_time {
        send::date_time(opt.get_timeout(), read::date_time());
        return;
    }

    if opt.battery {
        send::battery(opt.get_timeout(), read::battery());
        return;
    }

    if opt.network {
        send::network(opt.get_timeout(), read::network(opt.interface));
        return;
    }

    if opt.memory {
        send::memory(opt.get_timeout(), read::memory());
    }
}
