use libmacchina::traits::BatteryState;
use std::fmt;

pub struct Battery {
    percentage: u8,
    state: BatteryState,
}

impl Battery {
    pub fn new(p: u8, s: BatteryState) -> Self {
        Battery {
            percentage: p,
            state: s,
        }
    }
}

impl fmt::Display for Battery {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self.state {
            BatteryState::Charging => {
                write!(f, "Percentage: {}%\nState: Charging", self.percentage)
            }
            BatteryState::Discharging => {
                write!(f, "Percentage: {}%\nState: Discharging", self.percentage)
            }
        }
    }
}

pub enum Month {
    January,
    February,
    March,
    April,
    May,
    June,
    July,
    August,
    September,
    October,
    November,
    December,
}

impl From<u32> for Month {
    fn from(s: u32) -> Month {
        match s {
            1 => Month::January,
            2 => Month::February,
            3 => Month::March,
            4 => Month::April,
            5 => Month::May,
            6 => Month::June,
            7 => Month::July,
            8 => Month::August,
            9 => Month::September,
            10 => Month::October,
            11 => Month::November,
            _ => Month::December,
        }
    }
}

impl fmt::Display for Month {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match *self {
            Month::January => write!(f, "Jan"),
            Month::February => write!(f, "Feb"),
            Month::March => write!(f, "Mar"),
            Month::April => write!(f, "Apr"),
            Month::May => write!(f, "May"),
            Month::June => write!(f, "Jun"),
            Month::July => write!(f, "Jul"),
            Month::August => write!(f, "Aug"),
            Month::September => write!(f, "Sep"),
            Month::October => write!(f, "Oct"),
            Month::November => write!(f, "Nov"),
            Month::December => write!(f, "Dec"),
        }
    }
}

pub struct Time {
    days: u32,
    hours: u32,
    minutes: u32,
}

impl From<usize> for Time {
    fn from(seconds: usize) -> Time {
        let seconds = seconds as f32;
        let d = (seconds / 60.0 / 60.0 / 24.0).floor();
        let h = (seconds / 60.0 / 60.0 % 24.0).floor();
        let m = (seconds / 60.0 % 60.0).floor();

        Time {
            days: d as u32,
            hours: h as u32,
            minutes: m as u32,
        }
    }
}

impl fmt::Display for Time {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        let mut compiled: Vec<String> = vec![];

        match self.days {
            0 => (),
            1 => compiled.push("1 day".to_string()),
            d => compiled.push(format!("{} days", d)),
        }

        match self.hours {
            0 => (),
            1 => compiled.push("1 hour".to_string()),
            h => compiled.push(format!("{} hours", h)),
        }

        match self.minutes {
            0 => (),
            1 => compiled.push("1 minute".to_string()),
            m => compiled.push(format!("{} minutes", m)),
        }

        write!(f, "{}", compiled.join(", "))
    }
}
