use structopt::StructOpt;

#[derive(Debug, StructOpt)]
pub struct Opt {
    /// Sets the timeout for all the notifiers.
    #[structopt(
        long = "timeout",
        short = "t",
        help = "Specify how long (in seconds) notifications appear for"
    )]
    timeout: u32,

    /// Notifies you about your system's uptime.
    #[structopt(
        long = "uptime",
        short = "u",
        help = "Send a notification with uptime information"
    )]
    pub uptime: bool,

    /// Notifies you about your system's date and time.
    #[structopt(
        long = "date",
        short = "d",
        help = "Send a notification with date information"
    )]
    pub date_time: bool,

    /// Notifies you about your system's battery percentage and status.
    #[structopt(
        long = "battery",
        short = "b",
        help = "Send a notification with battery information"
    )]
    pub battery: bool,

    /// Notifies you about your system's networking status.
    #[structopt(
        long = "network",
        short = "n",
        help = "Send a notification with network information"
    )]
    pub network: bool,

    /// Notifies you about your system's memory usage.
    #[structopt(
        long = "memory",
        short = "m",
        help = "Send a notification with memory information"
    )]
    pub memory: bool,

    /// Specify an interface for the network notifier.
    #[structopt(
        long = "interface",
        short = "i",
        help = "Specify the interface for the network notification"
    )]
    pub interface: Option<String>,
}

impl Default for Opt {
    fn default() -> Self {
        Opt {
            timeout: 5,
            uptime: false,
            date_time: false,
            battery: false,
            network: false,
            memory: false,
            interface: None,
        }
    }
}

impl Opt {
    pub fn get_timeout(&self) -> u32 {
        self.timeout * 1000
    }
}
