# citron

_citron_ — ditch your panel for some snazzy desktop notifications.

It is: 
- a non-intrusive alternative to panels.
- extremely fast, thanks to [libmacchina](https://github.com/Macchina-CLI/libmacchina).
- works across different distributions, window managers and desktop environments.

## Usage

Set a keybinding to one or all of _citron_'s functionalities (see `--help`), and watch it do its _magic_ 🪄

Here's what this would look like on [sway](https://swaywm.org/):

```bash
bindsym $mod+Alt+d  exec citron -d -t 5 # Date
bindsym $mod+Alt+u  exec citron -u -t 5 # Uptime
bindsym $mod+Alt+b  exec citron -b -t 5 # Battery
bindsym $mod+Alt+m  exec citron -m -t 5 # Memory
bindsym $mod+Alt+n  exec citron -n -t 5 -i wlan0 # Network
```

## Features

It can notify you about your:
- [x] Date
- [x] Uptime
- [x] Battery
- [x] Memory
- [x] Network

## Installation

```
cargo install citron
```

## FAQ

### Why?

Have you ever looked at your computer screen and wondered: _"man, how many more pixels can I squeeze out of my computer?"_... You have? _"What a ner-"_ — Just kidding! 

*Ahem*, if this sounds intriguing to you then ditch your panel and let's get you back those 30 something pixels!
