use super::components::*;
use serde::{Deserialize, Serialize};
use std::fs;
use std::path::PathBuf;

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Config {
    pub date: Option<Date>,
    pub network: Option<Network>,
    pub backlight: Option<Backlight>,
    pub battery: Option<Battery>,
    pub memory: Option<Memory>,
    pub uptime: Option<Uptime>,
    pub icon: Option<Icon>,
    pub timeout: Option<u32>,
}

impl Config {
    pub fn read_config() -> Option<Config> {
        let path = if let Ok(dot_config) = std::env::var("XDG_CONFIG_HOME") {
            PathBuf::from(dot_config).join("citron").join("config.yml")
        } else if let Ok(home) = std::env::var("HOME") {
            PathBuf::from(home)
                .join(".config")
                .join("citron")
                .join("config.yml")
        } else {
            return None;
        };

        if let Ok(file) = fs::File::open(path) {
            let config: Config = serde_yaml::from_reader(file).expect("Could not read values.");
            return Some(config);
        }

        None
    }
}
