CITRON(1)

# NAME

citron - system data via on-demand notifications. 

# SYNOPSIS

*citron* [FLAGS]

*citron* [SUBCOMMAND]

# FLAGS

*-h, --help*
	Prints help information.

*-V, --version*
	Prints version information.

*-D, --debug*
	Prints debug information.

*-L*
	Prints a list of available icon themes.

# SUBCOMMANDS

*date*
	Shows a date notification.

*memory*
	Shows a memory notification.

*uptime*
	Shows an uptime notification.

*network*
	Shows a network notification.

*battery*
	Shows a battery notification.

*backlight*
	Shows a backlight notification.

# CONFIGURATION

*$XDG_CONFIG_HOME/citron/config.yml*, *$HOME/.config/citron/config.yml*.

## timeout: 
	Defines the amount of time (in seconds) notifications are visible for.

	Default: 5

## icon:

theme:
	Defines the name of the icon theme to use, which must be installed
	beforehand. Omitting this disables the usage of icons.

	*-L* flag provides a list of icon themes that this option can be set to.

	Example: "Papirus-Dark"

## date:

title:
	Defines the title of the notification.

	Default: "Date"

format:
	Defines the format of the notification's body.
	See DATE SYMBOLS for more information.

	Default: "%w, %m %d at %HH:MM %P"

## network:

title:
	Defines the title of the notification.

	Default: "Network"

format:
	Defines the format of the notification's body.
	See NETWORK SYMBOLS for more information.

	Default: "Local IP: %a\\nData: %r 🠗 / %t 🠕"


interface:
	Defines the name of the interface whose information will be queried, this is
	required for *citron network* to work.

	Example: "wlan0"

## battery:

title:
	Defines the title of the notification.

	Default: "Battery"

format:
	Defines the format of the notification's body.
	See BATTERY SYMBOLS for more information.

	Default: "Percentage: %p\\nState: %s"

## backlight:

title:
	Defines the title of the notification.

	Default: "Backlight"

## uptime:

title:
	Defines the title of the notification.

	Default: "Uptime"

## memory:

title:
	Defines the title of the notification.

	Default: "Memory"

## DATE SYMBOLS

[- *Symbol*
:[ *Description*
|  *%w*
:  Short weekday, e.g. Thu
|  *%W*
:  Long weekday, e.g. Thursday
|  *%m*
:  Short month, e.g. Jan
|  *%M*
:  Long month, e.g. January
|  *%d*
:  Day, e.g. 28
|  *%HH*
:  Hours
|  *%MM*
:  Minutes
|  *%P*
:  Meridiem. If omitted, railway time is used instead.

## BATTERY SYMBOLS

[- *Symbol*
:[ *Description*
|  *%p*
:  Percentage
|  *%s*
:  State

## NETWORK SYMBOLS

The following is a list of symbols understood by the format option of the
network dictionary.

[- *Symbol*
:[ *Description*
|  *%a*
:  Local IP address
|  *%r*
:  Number of received bytes
|  *%t*
:  Number of transmitted bytes

# AUTHOR

Written and maintained by Aziz Ben Ali <ba.tahaaziz@gmail.com>.

# RESOURCES

This project is hosted at *https://git.sr.ht/~grtcdr/citron*. Bugs and patches
should be submitted via email to *~grtcdr/citron@lists.sr.ht*.
