use serde::{Deserialize, Serialize};

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Network {
    pub title: Option<String>,
    pub interface: Option<String>,
    pub format: Option<String>,
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Date {
    pub title: Option<String>,
    pub format: Option<String>,
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Icon {
    pub theme: Option<String>,
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Battery {
    pub title: Option<String>,
    pub format: Option<String>,
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Backlight {
    pub title: Option<String>,
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Uptime {
    pub title: Option<String>,
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Memory {
    pub title: Option<String>,
}

impl Date {
    pub fn is_railway(&self) -> bool {
        if let Some(format) = &self.format {
            !format.contains("%P")
        } else {
            false
        }
    }
}
