use std::fmt;

#[derive(Clone, Copy, Debug, PartialEq)]
pub enum Month {
    January,
    February,
    March,
    April,
    May,
    June,
    July,
    August,
    September,
    October,
    November,
    December,
}

impl From<u32> for Month {
    fn from(s: u32) -> Month {
        match s {
            1 => Month::January,
            2 => Month::February,
            3 => Month::March,
            4 => Month::April,
            5 => Month::May,
            6 => Month::June,
            7 => Month::July,
            8 => Month::August,
            9 => Month::September,
            10 => Month::October,
            11 => Month::November,
            _ => Month::December,
        }
    }
}

impl Month {
    pub fn short(self) -> impl fmt::Display {
        struct Short(Month);
        impl fmt::Display for Short {
            fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
                match self.0 {
                    Month::January => write!(f, "Jan"),
                    Month::February => write!(f, "Feb"),
                    Month::March => write!(f, "Mar"),
                    Month::April => write!(f, "Apr"),
                    Month::May => write!(f, "May"),
                    Month::June => write!(f, "Jun"),
                    Month::July => write!(f, "Jul"),
                    Month::August => write!(f, "Aug"),
                    Month::September => write!(f, "Sep"),
                    Month::October => write!(f, "Oct"),
                    Month::November => write!(f, "Nov"),
                    Month::December => write!(f, "Dec"),
                }
            }
        }
        Short(self)
    }

    pub fn long(self) -> impl fmt::Display {
        struct Long(Month);
        impl fmt::Display for Long {
            fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
                match self.0 {
                    Month::January => write!(f, "January"),
                    Month::February => write!(f, "February"),
                    Month::March => write!(f, "March"),
                    Month::April => write!(f, "April"),
                    Month::May => write!(f, "May"),
                    Month::June => write!(f, "June"),
                    Month::July => write!(f, "July"),
                    Month::August => write!(f, "August"),
                    Month::September => write!(f, "September"),
                    Month::October => write!(f, "October"),
                    Month::November => write!(f, "November"),
                    Month::December => write!(f, "December"),
                }
            }
        }
        Long(self)
    }
}
