use serde::{Deserialize, Serialize};

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Network {
    title: Option<String>,
    interface: Option<String>,
    format: Option<String>,
}

impl Network {
    pub fn get_title(&self) -> Option<String> {
        self.title.to_owned()
    }

    pub fn get_format(&self) -> Option<String> {
        self.format.to_owned()
    }

    pub fn get_interface(&self) -> Option<String> {
        self.interface.to_owned()
    }
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Date {
    title: Option<String>,
    format: Option<String>,
}

impl Date {
    pub fn get_format(&self) -> Option<String> {
        self.format.to_owned()
    }

    pub fn get_title(&self) -> Option<String> {
        self.title.to_owned()
    }

    pub fn is_railway(&self) -> bool {
        if let Some(format) = &self.format {
            !format.contains("%P")
        } else {
            false
        }
    }
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Icon {
    theme: Option<String>,
}

impl Icon {
    pub fn get_theme(&self) -> Option<String> {
        self.theme.to_owned()
    }
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Battery {
    title: Option<String>,
    format: Option<String>,
}

impl Battery {
    pub fn get_title(&self) -> Option<String> {
        self.title.to_owned()
    }

    pub fn get_format(&self) -> Option<String> {
        self.format.to_owned()
    }
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Backlight {
    title: Option<String>,
}

impl Backlight {
    pub fn get_title(&self) -> Option<String> {
        self.title.to_owned()
    }
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Memory {
    title: Option<String>,
}

impl Memory {
    pub fn get_title(&self) -> Option<String> {
        self.title.to_owned()
    }
}

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Uptime {
    title: Option<String>,
}

impl Uptime {
    pub fn get_title(&self) -> Option<String> {
        self.title.to_owned()
    }
}
