use super::extra::*;
use serde::{Deserialize, Serialize};
use std::fs;

#[derive(Default, Debug, Serialize, Deserialize)]
pub struct Config {
    date: Option<Date>,
    network: Option<Network>,
    backlight: Option<Backlight>,
    battery: Option<Battery>,
    memory: Option<Memory>,
    uptime: Option<Uptime>,
    icon: Option<Icon>,
    timeout: Option<u32>,
}

impl Config {
    pub fn get_timeout(&self) -> Option<u32> {
        self.timeout
    }

    pub fn get_date(&self) -> Option<&Date> {
        self.date.as_ref()
    }

    pub fn get_network(&self) -> Option<&Network> {
        self.network.as_ref()
    }

    pub fn get_memory(&self) -> Option<&Memory> {
        self.memory.as_ref()
    }

    pub fn get_uptime(&self) -> Option<&Uptime> {
        self.uptime.as_ref()
    }

    pub fn get_battery(&self) -> Option<&Battery> {
        self.battery.as_ref()
    }

    pub fn get_backlight(&self) -> Option<&Backlight> {
        self.backlight.as_ref()
    }

    pub fn get_icon(&self) -> Option<&Icon> {
        self.icon.as_ref()
    }

    pub fn read_config() -> Option<Config> {
        if let Some(home_dir) = dirs::config_dir() {
            let config_path = home_dir.join("citron").join("config.yml");
            if let Ok(file) = fs::File::open(config_path) {
                let config: Config = serde_yaml::from_reader(file).expect("Could not read values.");
                return Some(config);
            }
        }

        None
    }
}
