//! This module contains the different formatters for citron.
//! The idea behind formatters is to separate reading (data) and formatting (it):
//! - Their main purpose is to take the data that they're passed, and then format it in specific
//! ways.
//! - They also have control over the icons they use.

pub mod backlight;
pub mod battery;
pub mod date;
pub mod memory;
pub mod network;
pub mod uptime;

pub trait Iconize {
    fn set_icon(&self, icon: &mut crate::Icon);
}
