use ethereum_types::H256;
use hasher::Hasher;

#[cfg(feature = "sha3hash")]
pub const NIL_DATA: H256 = H256([
    0xc5, 0xd2, 0x46, 0x01, 0x86, 0xf7, 0x23, 0x3c, 0x92, 0x7e, 0x7d, 0xb2, 0xdc, 0xc7, 0x03, 0xc0, 0xe5, 0x00, 0xb6,
    0x53, 0xca, 0x82, 0x27, 0x3b, 0x7b, 0xfa, 0xd8, 0x04, 0x5d, 0x85, 0xa4, 0x70,
]);

#[cfg(feature = "sha3hash")]
pub const RLP_NULL: H256 = H256([
    0x56, 0xe8, 0x1f, 0x17, 0x1b, 0xcc, 0x55, 0xa6, 0xff, 0x83, 0x45, 0xe6, 0x92, 0xc0, 0xf8, 0x6e, 0x5b, 0x48, 0xe0,
    0x1b, 0x99, 0x6c, 0xad, 0xc0, 0x01, 0x62, 0x2f, 0xb5, 0xe3, 0x63, 0xb4, 0x21,
]);

#[cfg(feature = "sha3hash")]
pub fn get_hasher() -> hasher::HasherKeccak {
    hasher::HasherKeccak::new()
}

#[cfg(feature = "blake2bhash")]
pub const NIL_DATA: H256 = H256([
    0xd6, 0x7f, 0x72, 0x9f, 0x8d, 0x19, 0xed, 0x2e, 0x92, 0xf8, 0x17, 0xcf, 0x5c, 0x31, 0xc7, 0x81, 0x2d, 0xd3, 0x9e,
    0xd3, 0x5b, 0x0b, 0x1a, 0xae, 0x41, 0xc7, 0x66, 0x5f, 0x46, 0xc3, 0x6b, 0x9f,
]);

#[cfg(feature = "blake2bhash")]
pub const RLP_NULL: H256 = H256([
    0xc1, 0x4a, 0xf5, 0x91, 0x07, 0xef, 0x14, 0x00, 0x3e, 0x46, 0x97, 0xa4, 0x0e, 0xa9, 0x12, 0xd8, 0x65, 0xeb, 0x14,
    0x63, 0x08, 0x6a, 0x46, 0x49, 0x97, 0x7c, 0x13, 0xea, 0x69, 0xb0, 0xd9, 0xaf,
]);

#[cfg(feature = "blake2bhash")]
pub fn get_hasher() -> hasher::HasherBlake2B {
    hasher::HasherBlake2B::new("CryptapeCryptape".as_bytes().to_vec())
}

#[cfg(feature = "sm3hash")]
pub const NIL_DATA: H256 = H256([
    0x1a, 0xb2, 0x1d, 0x83, 0x55, 0xcf, 0xa1, 0x7f, 0x8e, 0x61, 0x19, 0x48, 0x31, 0xe8, 0x1a, 0x8f, 0x22, 0xbe, 0xc8,
    0xc7, 0x28, 0xfe, 0xfb, 0x74, 0x7e, 0xd0, 0x35, 0xeb, 0x50, 0x82, 0xaa, 0x2b,
]);

#[cfg(feature = "sm3hash")]
pub const RLP_NULL: H256 = H256([
    0x99, 0x5b, 0x94, 0x98, 0x69, 0xf8, 0x0f, 0xa1, 0x46, 0x5a, 0x9d, 0x8b, 0x6f, 0xa7, 0x59, 0xec, 0x65, 0xc3, 0x02,
    0x0d, 0x59, 0xc2, 0x62, 0x46, 0x62, 0xbd, 0xff, 0x05, 0x9b, 0xdf, 0x19, 0xb3,
]);

#[cfg(feature = "sm3hash")]
pub fn get_hasher() -> hasher::HasherSM3 {
    hasher::HasherSM3::new()
}

pub fn summary(data: &[u8]) -> Vec<u8> {
    get_hasher().digest(data).to_vec()
}
