use crate::{Ellipse, Float, Point};
use std::ops::Div;

impl Ellipse {
    /// Create a new ellipse with the coefficient of equation.
    ///
    /// $$A x^2 + B y^2 + C xy + D x + E y + F = 0$$
    pub fn from_coefficient(a: Float, b: Float, c: Float, d: Float, e: Float, f: Float) -> Self {
        Self { a, b: b.div(2.0), c, d: d.div(2.0), e: e.div(2.0), f }
    }
    /// Create a new ellipse with the center and the two axes and .
    pub fn from_transform(center: &Point, major: Float, minor: Float, rotate: Float) -> Self {
        todo!()
    }
    /// Create a new ellipse with 5 points.
    pub fn from_5_points(p1: &Point, p2: &Point, p3: &Point, p4: &Point, p5: &Point) {}
}
impl Ellipse {
    /// Return the center of the ellipse.
    pub fn get_parameter(&self) -> (Float, Float, Float, Float, Float, Float) {
        (self.a, self.b, self.c, self.d, self.e, self.f)
    }
    /// Get the parameter of the ellipse.
    ///
    /// ```math
    /// f(x) = \int_{-\infty}^\infty
    ///   \hat f(\xi)\,e^{2 \pi i \xi x}
    ///   \,d\xi
    /// ```
    pub fn get_parameter_matrix(&self) -> [[Float; 3]; 3] {
        [[self.a, self.b, self.d], [self.d, self.c, self.e], [self.d, self.e, self.f]]
    }
    /// Return the major axis of the ellipse.
    pub fn get_transform(&self) -> (Point, Float, Float, Float) {
        todo!()
    }
    /// Return the major axis of the ellipse.
    pub fn get_transform_matrix(&self) -> [[Float; 3]; 3] {
        todo!()
    }
    /// Return the major axis of the ellipse.
    pub fn get_standard_form(&self) -> Point {
        todo!()
    }
    /// Return the major axis of the ellipse.
    pub fn get_normal_form(&self) -> Point {
        todo!()
    }
}
