use crate::{Float, Point};

impl Point {
    /// View point as tuple
    pub fn as_tuple(&self) -> (Float, Float) {
        (self.x, self.y)
    }
    /// Distance between two points.
    pub fn distance_to(&self, other: &Self) -> Float {
        let dx = self.x - other.x;
        let dy = self.y - other.y;
        (dx * dx + dy * dy).sqrt()
    }
}

impl From<(Float, Float)> for Point {
    fn from(point: (Float, Float)) -> Self {
        Self { x: point.0, y: point.1 }
    }
}
