use crate::{π, Circle, Float, Point};

impl Circle {
    /// Returns the area of the circle.
    pub fn area(&self) -> Float {
        π * self.radius * self.radius
    }
    /// Returns the circumference of the circle.
    pub fn perimeter(&self) -> Float {
        2.0 * π * self.radius
    }
    /// Checks if the circle contains the given point.
    pub fn contains(&self, point: &Point) -> bool {
        self.center.distance_to(point) <= self.radius
    }
}
