#![allow(non_upper_case_globals)]
// #![deny(missing_docs)]
// #![deny(missing_debug_implementations)]
// #![doc = include_str!("../Readme.md")]

// mod circle;
// mod point;
// mod traits;

pub use float::{Float, Pi};

#[derive(Clone, Copy, Debug, PartialEq)]
pub struct Point {
    pub x: Float,
    pub y: Float,
}

/// A ball in n-dimensional space.
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct Circle {
    /// Center of the circle.
    pub center: Point,
    /// Radius of the circle.
    pub radius: Float,
}

#[cfg(feature = "f32")]
mod float {
    /// Float Type
    pub type Float = f32;
    /// constant π
    pub const Pi: Float = std::f32::consts::PI;
}

#[cfg(feature = "f64")]
mod float {
    /// Float Type
    pub type Float = f64;
    /// constant π
    pub const Pi: Float = std::f64::consts::PI;
}
